import request from '@/utils/request';
import config from '../../../config/env.config';
import { stringify } from 'qs';
import _ from 'lodash';

const { goodsApi } = config;
const headers = {
  'Content-Type': 'application/x-www-form-urlencoded',
};
//
export const setShopList = async params => {
  const data = await request.post('/v1/channels/enterprise/shop/list', {
    prefix: goodsApi,
    data: params,
  });
  return data;
};

// [企业店铺]-删除企业下面的店铺
// http://yapi.quantgroups.com/project/389/interface/api/65319
export const setShopDelete = async params => {
  const data = await request.post('/v1/channels/enterprise/shop/delete', {
    prefix: goodsApi,
    data: params,
  });
  return data;
};

// [企业店铺]-查询餐品类型
// http://yapi.quantgroups.com/project/389/interface/api/65314
export const mealTypeList = async params => {
  const data = await request.post('/v1/channels/enterprise/shop/mealType/list', {
    prefix: goodsApi,
    data: params,
  });
  return data;
};

// [企业店铺]-添加企业店铺
// http://yapi.quantgroups.com/project/389/interface/api/65304
export const shopAdd = async params => {
  const data = await request.post('/v1/channels/enterprise/shop/add', {
    prefix: goodsApi,
    data: params,
  });
  return data;
};

// 企业店铺]-修改餐品类型
// http://yapi.quantgroups.com/project/389/interface/api/65309
export const shopUpdate = async params => {
  const data = await request.post('/v1/channels/enterprise/shop/update', {
    prefix: goodsApi,
    data: params,
  });
  return data;
};
