import request from '@/utils/request';
import config from '../../../config/env.config';
import { stringify } from 'qs';
import _ from 'lodash';

const { goodsApi } = config;

//  [企业员工]-列表查询
//  http://yapi.quantgroups.com/project/389/interface/api/65359
export const apiStaffList = async params => {
  const data = await request.post('/api/consoles/enterprise/staff/pageList', {
    prefix: goodsApi,
    data: params,
  });
  return data;
};

// [企业客户]-列表查询
// http://yapi.quantgroups.com/project/389/interface/api/65324
export const apiEnterpriseList = async () => {
  const data = await request.post('/api/consoles/enterprise/pageList', {
    prefix: goodsApi,
    data: {
      page: 1,
      size: 10000,
    },
  });
  return data;
};

// [企业部门]-列表查询
// http://yapi.quantgroups.com/project/389/interface/api/65344
export const apiDepartmentList = async params => {
  const data = await request.post('/api/consoles/enterprise/department/pageList', {
    prefix: goodsApi,
    data: params,
  });
  return data;
};

// [企业员工]-添加员工
// http://yapi.quantgroups.com/project/389/interface/api/65364
export const apiStaffSave = async params => {
  const data = await request.post('/api/consoles/enterprise/staff/save', {
    prefix: goodsApi,
    data: params,
  });
  return data;
};

// [企业员工]-导入员工
// http://yapi.quantgroups.com/project/389/interface/api/65384
export const apiStaffExcel = async file => {
  const params = new FormData();
  params.append('file', file);
  const data = await request.post('/api/consoles/enterprise/staff/excel', {
    prefix: goodsApi,
    data: params,
  });
  return data;
};

// [企业部门]-新增企业部门
// http://yapi.quantgroups.com/project/389/interface/api/65349
export const apiDepartmentSave = async params => {
  const data = await request.post('/api/consoles/enterprise/department/save', {
    prefix: goodsApi,
    data: params,
  });
  return data;
};

// [企业部门]-导入企业部门
// http://yapi.quantgroups.com/project/389/interface/api/65354
export const apiDepartmentExcel = async file => {
  const params = new FormData();
  params.append('file', file.file);
  params.append('enterpriseId', file.enterpriseId);
  const data = await request.post('/api/consoles/enterprise/department/excel', {
    prefix: goodsApi,
    data: params,
  });
  return data;
};
