import request from '@/utils/request';
import config from '@/../config/env.config';
import UUID from '@/utils/uuid';

const { goodsApi } = config;

// export const merchantUpload = async files => {
//   const params = new FormData();
//   files.forEach(file => params.append('file', file));
//   const data = await request.post('/image/api/merchant/upload', {
//     prefix: goodsApi,
//     data: params,
//   });
//   return data;
// };

export const apiFileUpload = async files => {
  const data = await Promise.all(
    files.map(async file => {
      const params = new FormData();
      params.append('file', file);
      const uuid = UUID.createUUID();
      if (file.name) {
        const arr = file.name.split('.');
        params.append('fileName', `${uuid}.${arr[arr.length - 1]}`);
      }
      const res = await request.post(`/api/merchants/images/uploadFile?id=${uuid}`, {
        prefix: goodsApi,
        data: params,
      });
      return res;
    }),
  );
  console.log('data', data);
  return data;
};
