import { ConsoleSqlOutlined } from '@ant-design/icons';

export const cleanArray = actual => {
  const newArray = [];
  // eslint-disable-next-line no-plusplus
  for (let i = 0; i < actual.length; i++) {
    if (actual[i]) {
      newArray.push(actual[i]);
    }
  }
  return newArray;
};

const createInitProduct = (skuItem, isCreate) => {
  if (isCreate && Object.keys(skuItem).length > 5) {
    return skuItem;
  }
  return {
    weight: null,
    productStockWarning: null,
    marketPrice: null,
    supplyPrice: null,
    stock: null,
    thirdSkuNo: null,
    skuLink: null,
    name: null,
  };
};

const initData = {
  weight: null,
  productStockWarning: null,
  marketPrice: null,
  supplyPrice: null,
  stock: null,
  thirdSkuNo: null,
  skuLink: null,
  name: null,
};

const createSecondProduct = (secondSpecList, initItem, secondSpec, dataSource, callback) => {
  secondSpecList.forEach(secondItem => {
    const specSecond =
      Object.keys(secondItem).length < 2
        ? {
            firstSpecId: initItem.firstSpecId,
            firstSpecValue: initItem.firstSpecValue,
            ...initData,
          }
        : Object.assign({}, initItem); // 继承fist参数

    if (callback) {
      callback(specSecond);
    }
    specSecond.secondSpecId = secondSpec;
    specSecond.secondSpecValue = secondItem.secondSpecValue;
    dataSource.push(specSecond);
  });
};

export const createProductData = ({ firstValues, secondValues, firstSpecId, secondSpecId }) => {
  console.log('=============>firstValues, secondValues', firstValues, secondValues);
  const countRowSpan = {};
  const dataSource = [];
  if (firstValues.length) {
    firstValues.forEach((fisrtItem, index) => {
      const specFirst = createInitProduct(fisrtItem, true);
      specFirst.firstSpecId = firstSpecId;
      specFirst.firstSpecValue = fisrtItem.firstSpecValue;
      if (secondSpecId && secondValues.length) {
        createSecondProduct(secondValues, specFirst, secondSpecId, dataSource, specSecond => {
          if (!countRowSpan[specFirst.firstSpecValue]) {
            countRowSpan[specFirst.firstSpecValue] = true;
            specSecond.rowSpanCount = secondValues.length;
          }
        });
        return;
      }
      dataSource.push(specFirst);
    });
  } else if (secondValues.length) {
    createSecondProduct(secondValues, initData, secondSpecId, dataSource);
  } else {
    const specFirst = createInitProduct();
    dataSource.push(specFirst);
  }
  console.log('dataSource===========>', dataSource);
  return dataSource;
};

export const isUrl = path => {
  // eslint-disable-next-line no-useless-escape
  const reg = /(((^https?:(?:\/\/)?)(?:[-;:&=\+\$,\w]+@)?[A-Za-z0-9.-]+(?::\d+)?|(?:www.|[-;:&=\+\$,\w]+@)[A-Za-z0-9.-]+)((?:\/[\+~%\/.\w-_]*)?\??(?:[-\+=&;%@.\w_]*)#?(?:[\w]*))?)$/;
  return reg.test(path);
};

export const batchTableSourceData = ({ batchItem, tableData, bacthSecon, bacthFirst }) => {
  const batchItemKey = Object.keys(batchItem);
  return tableData.map((item, index) => {
    if (!bacthFirst && !bacthSecon) {
      batchItemKey.forEach(key => {
        item[key] = batchItem[key] || null;
      });
    }
    if (bacthFirst && !bacthSecon) {
      batchItemKey.forEach(key => {
        if (item.firstSpecValue === bacthFirst) {
          item[key] = batchItem[key] || null;
        }
      });
    }
    if (!bacthFirst && bacthSecon) {
      batchItemKey.forEach(key => {
        if (item.secondSpecValue === bacthSecon) {
          item[key] = batchItem[key] || null;
        }
      });
    }
    if (bacthFirst && bacthSecon) {
      batchItemKey.forEach(key => {
        if (item.firstSpecValue === bacthFirst && item.secondSpecValue === bacthSecon) {
          item[key] = batchItem[key] || null;
        }
      });
    }
    return item;
  });
};
