import React, { useState, useRef, useEffect, useCallback } from 'react';
import { Spin, Button, Modal, notification } from 'antd';
import { ConsoleSqlOutlined } from '@ant-design/icons';
import { Title, WrapperContainer } from './components/CommonTemplate';
import { TaskTypeSelect } from './components/TaskTypeSelect';
import FormInformationBasic from './components/FormInformationBasic';
import FormPriceOrStock from './components/FormPriceOrStock';
import FormRuleSetting from './components/FormRuleSetting';
import FormRuleVPictures from './components/FormRuleVPictures';
import FormSettlementOthers from './components/FormSettlementOthers';
import {
  getProductDetail,
  merchantCategoryGetAll,
  merchantBrandList,
  merchantSpecList,
  afterSalesAddrsPage,
  merchantgetJdPicList,
} from './service';
import { isUrl } from './utils';
import { ServiceContext } from './context';

/**
 * 服务商品改造-商品模块
 * @param {*} router options
 * @returns ReactDOM
 */
const ServiceGoods = options => {
  const { SourceData, categoryList, specListData } = options;

  const basicRef = useRef(null);
  const stockRef = useRef(null);
  const settingRef = useRef(null);
  const picturesRef = useRef(null);
  const settleOtrRef = useRef(null);

  const [pageId, setPageId] = useState(null);
  const [isEdit, setIsEdit] = useState(false); // 是否是编辑状态
  const [productType, setProductType] = useState(1); // 商品状态
  const [pageLoading, setPageLoading] = useState(false); // 页面加载状态
  // const [categoryList, setCategoryList] = useState([]); // 获取三级类目
  const [afterAddressList, setAfterAddressList] = useState([]);

  const [brandList, setBrandList] = useState([]); // 获取商品牌
  const [specList, setSpecList] = useState([]); // 规格列表
  const [editData, setEditData] = useState({}); // 编辑保存数据
  const baseCheckList = [basicRef, stockRef, picturesRef];
  const [checkFormList, setCheckFormList] = useState(baseCheckList);

  const [specKeyList, setSpecKeyList] = useState([]); // 记录一级规格key字段

  const changeCheckList = proType => {
    const newBaseCheckList =
      proType === 3 ? [...baseCheckList, settingRef, settleOtrRef] : baseCheckList;
    setCheckFormList(newBaseCheckList);
  };

  const resetForm = () => {
    checkFormList.forEach(({ current }) => {
      if (current) {
        current.reset();
      }
    });
  };

  // useEffect(() => {
  //   const timer = setTimeout(() => {
  //     console.log(checkFormList);

  //     clearTimeout(timer);
  //   }, 1000);
  // }, [checkFormList, options.visible]);

  const productChange = task => {
    setProductType(task.type);
    changeCheckList(task.type);
  };

  const submitEvent = async () => {
    const checkPromiseList = checkFormList.map(({ current }) => current.onCheck());
    const resuslt = await Promise.all(checkPromiseList);
    console.log(resuslt);
  };

  // 编辑回显详情数据
  const getProductDetailResponse = async id => {
    try {
      const res = await getProductDetail(id);
      if (res && res.data) {
        setProductType(res.data.type);
        setEditData(res.data);
      }
    } catch (err) {
      console.log('接口调用失败！');
    }
  };

  // 获取三级类目分类数据
  const getMerchantCategory = async () => {
    const result = await merchantCategoryGetAll();
    // setCategoryList(result.data || []);
  };
  // 获取商品牌数据
  const getMerchantBrandList = async () => {
    if (!brandList.length) {
      const result = await merchantBrandList();
      setBrandList(result.data || []);
    }
  };
  // 获取规格列表
  const getMerchantSpecList = async () => {
    if (!specList.length) {
      const result = await merchantSpecList();
      setSpecList(result.data || []);
    }
  };

  const getAfterSalesAddrsPage = async () => {
    if (!afterAddressList.length) {
      const result = await afterSalesAddrsPage();
      setAfterAddressList(result.data.records);
    }
  };

  const getMerchantgetJdPicList = async params => {
    const result = await merchantgetJdPicList(params);
    if (result) {
      const { detailImageList, imageList } = picturesRef.current.getFieldsValue();
      const detailList = result.detailList || [];
      const newImageList = imageList[result.firstSpecValue];
      const carouseList = result.carouseList || [];
      imageList[result.firstSpecValue] = newImageList
        ? [...newImageList, ...carouseList]
        : carouseList;
      picturesRef.current.setFieldsValue({
        // [`imageList[${data.firstSpecValue}]`]: this.state.colorImg[data.firstSpecValue],
        imageList,
        detailImageList: [...detailImageList, ...detailList],
      });
    }
  };

  useEffect(() => {
    (async () => {
      if (!options.visible) {
        return;
      }
      setPageLoading(true);
      await getMerchantBrandList();
      await getAfterSalesAddrsPage();
      await getMerchantSpecList();
      if (Object.keys(SourceData).length) {
        // const isService = initData.state && initData.state !== 4;
        setEditData(SourceData);
        setPageId(options.id);
        setProductType(SourceData.productType);
        changeCheckList(SourceData.productType);
        setIsEdit(true);
      }
      setPageLoading(false);

      // setPageLoading(true);
      // await getMerchantCategory();
      // await getMerchantBrandList();
      // await getMerchantSpecList();
      // if (options.id) {
      //   setIsEdit(true);
      //   await getProductDetailResponse(options.id);
      //   changeCheckList(productType);
      // }
      // setPageLoading(false);
    })();
  }, [SourceData]);

  const handleOk = () => {};

  const handleCancel = () => {
    setPageId(null);
    setIsEdit(false);
    setProductType(1);
    setEditData({});
    setSpecKeyList([]);
    resetForm();
    options.onChange(false);
  };

  const onSpecCommonImgEvent = useCallback(
    keys => {
      setSpecKeyList(keys);
    },
    [specKeyList],
  );

  const onEventBus = (event, params) => {
    if (event === 'cloneImg') {
      if (!isUrl(params.skuLink)) {
        notification.open({
          message: '提示',
          description: '请输入正确的URL！',
        });
        return;
      }
      getMerchantgetJdPicList({
        firstSpecId: params.firstSpecId,
        firstSpecValue: params.firstSpecValue,
        secondSpecId: params.secondSpecId,
        secondSpecValue: params.secondSpecValue,
        skuLink: params.skuLink,
        jdSkuInfoUrl: params.skuLink,
      });
    }

    console.log(event, params);
  };

  const providerValue = {
    pageId,
    isEdit,
    productType,
    isCard: productType === 3,
    isService: SourceData.state && SourceData.state !== 4,
    isJDGoods: isEdit && SourceData.pageProductType && +SourceData.pageProductType !== 1,
    onEventBus,
  };

  return (
    <Modal visible={options.visible} onOk={handleOk} onCancel={handleCancel} width={1366}>
      <Spin tip="正在加载..." spinning={pageLoading} delay={100}>
        <WrapperContainer>
          <ServiceContext.Provider value={providerValue}>
            <Title title="商品类型" />
            <TaskTypeSelect productType={productType} onChange={productChange} />

            <Title title="商品基本信息编辑" />
            <FormInformationBasic
              ref={basicRef}
              editData={editData.infoMation}
              categoryList={categoryList}
              brandList={brandList}
              afterAddressList={afterAddressList}
              specListData={specListData}
            />

            <Title title="价格与库存" />
            <FormPriceOrStock
              ref={stockRef}
              specList={specList}
              onSpecChange={onSpecCommonImgEvent}
              editData={editData.infoSpecData}
              skuList={editData.skuList}
            />

            {/* <Title title="规则设置" />
            {productType === 3 && <FormRuleSetting ref={settingRef} editData={editData} />} */}

            <FormRuleVPictures
              ref={picturesRef}
              specKeyItem={specKeyList}
              editData={editData.infoImageData}
            />
            {/* {productType === 3 && <FormSettlementOthers ref={settleOtrRef} editData={editData} />} */}
            <Button type="primary" onClick={submitEvent}>
              Register
            </Button>
          </ServiceContext.Provider>
        </WrapperContainer>
      </Spin>
    </Modal>
  );
};

export default ServiceGoods;
