import { PlusOutlined } from '@ant-design/icons';
import { Modal, Upload, notification, Spin } from 'antd';
import React, { useState, useEffect, useRef } from 'react';
import lodash from 'lodash';
import { merchantUpload } from '../service';

const MAX_FILE_SIZE = 5;
const UNIT = 1024 * 1024;

// const getBase64 = (file: RcFile): Promise<string> =>
//   new Promise((resolve, reject) => {
//     const reader = new FileReader();
//     reader.readAsDataURL(file);
//     reader.onload = () => resolve(reader.result.toString());
//     reader.onerror = error => reject(error);
//   });

const uploadButton = (
  <div>
    <PlusOutlined />
    <div style={{ marginTop: 8 }}>Upload</div>
  </div>
);

const UploadImage = props => {
  const {
    name = `${Date.now()}`,
    limit = 1,
    uploadParams,
    pictures = [],
    onChange = () => {},
    setPictureList = () => {},
  } = props;
  const [uploadLoading, setUploadLoading] = useState(false);
  const [previewVisible, setPreviewVisible] = useState(false);
  const [previewImage, setPreviewImage] = useState('');
  const [previewTitle, setPreviewTitle] = useState('');
  const [fileList, setFileList] = useState([]);
  const fileListRef = useRef([]);

  useEffect(() => {
    const newPictures = pictures.map((url, ind) => ({
      url,
      name: url,
      uid: `${ind}`,
    }));
    fileListRef.current = [...newPictures];
    setFileList([...newPictures]);
  }, [pictures]);

  const handleCancel = () => setPreviewVisible(false);

  const handlePreview = async file => {
    setPreviewImage(file.url);
    setPreviewVisible(true);
    setPreviewTitle(file.name || file.url.substring(file.url.lastIndexOf('/') + 1));
  };

  const bundleChange = imgFile => {
    const imgList = imgFile.map(item => item.url);
    setPictureList(imgList);
    onChange(imgList);
  };

  const handleRemove = file => {
    const freshFiles = fileList?.filter(ele => ele.uid !== file.uid);
    bundleChange(freshFiles);
  };
  // const saveFiles = (file, ret) => {
  //   return new Promise((resolve) => {
  //     const reader = new FileReader();
  //     // 监听图片转换完成
  //     reader.addEventListener('load',
  //       () => {
  //         // ...接入antd upload 的 filelist 中
  //         // if (typeof setPictureList === 'function') {
  //         const temFile = { uid: file.uid, status: 'done', name: file.name, url: ret };
  //         let newFiles = [...fileListRef.current, temFile];
  //         if (!uploadParams.multiple) {
  //           // 只保留最后一个文件
  //           newFiles = newFiles.slice(-1);
  //         }
  //         bundleChange(newFiles);
  //         // }
  //       },
  //       false,
  //     );
  //     reader.readAsDataURL(file);

  //   })
  //   // 图片转换成base64编码作为缩略图
  // };
  // const customRequestObject = async params => {
  //   console.log(fileList.length);
  //   const { file, onSuccess, onError } = params;
  //     try {
  //       const res = await merchantUpload([file]);
  //       const [url] = res.data;
  //       onSuccess();
  //       saveFiles(file, url);
  //       setFileList(preFileList => preFileList.map(item => id === item.uid ? { ...item, status: 'done', url, percent: 100,} : item));
  //     } catch(error) {
  //       onError();
  //       console.log(error);
  //     }
  // };

  const checkFile = file =>
    new Promise(resolve => {
      const curType = file.name.substr(file.name.lastIndexOf('.') + 1).toLowerCase();
      const fileType = ['jpg', 'jpeg', 'png'];
      if (!fileType.includes(curType)) {
        notification.open({
          message: file.name,
          description: '图片格式须为jpg、jpeg、png！',
        });
        return resolve(null);
      }
      if (file.size > MAX_FILE_SIZE * UNIT) {
        notification.open({
          message: file.name,
          description: `单个图片大小不能超过${MAX_FILE_SIZE}M！`,
        });
        return resolve(null);
      }
      return resolve(file);
    });

  const imageLoading = (file, ret) =>
    new Promise(resolve => {
      const reader = new FileReader();
      // 监听图片转换完成
      reader.addEventListener(
        'load',
        () => {
          const temFile = { uid: file.uid, status: 'done', name: file.name, url: ret };
          resolve(temFile);
        },
        false,
      );
      reader.readAsDataURL(file);
    });

  const defaultBeforeUpload = lodash.debounce(
    (file, fileArray) =>
      // 文件显示
      new Promise(async () => {
        if (fileListRef.current.length + fileArray.length > limit) {
          Modal.warning({
            maskClosable: true,
            title: '超出上传个数',
          });
          return Upload.LIST_IGNORE;
        }
        const fileAll = fileArray.map(item => checkFile(item));
        const checkFiles = (await Promise.all(fileAll)).filter(item => item !== null);
        try {
          if (checkFiles.length) {
            setUploadLoading(true);
            const res = await merchantUpload(checkFiles);
            const proFiles = (res.data || []).map((urlItem, urlIndex) =>
              imageLoading(checkFiles[urlIndex], urlItem),
            );
            const imagList = await Promise.all(proFiles);
            const newFiles = [...fileListRef.current, ...imagList];
            bundleChange(newFiles);
            setUploadLoading(false);
          }
        } catch (error) {
          setUploadLoading(false);
          Modal.warning({
            maskClosable: true,
            title: '上传失败，请重新尝试！',
          });
        }
        return null;
      }),
  );

  return (
    <Spin tip="正在上传..." spinning={uploadLoading} delay={100}>
      <Upload
        {...uploadParams}
        multiple={limit > 1}
        name={name}
        customRequest={() => {}}
        listType="picture-card"
        beforeUpload={defaultBeforeUpload}
        fileList={fileList}
        onPreview={handlePreview}
        onRemove={handleRemove}
      >
        {fileList.length >= props.limit ? null : uploadButton}
      </Upload>
      <Modal visible={previewVisible} title={previewTitle} footer={null} onCancel={handleCancel}>
        <img alt="example" style={{ width: '100%' }} src={previewImage} />
      </Modal>
    </Spin>
  );
};

export default UploadImage;
