/* eslint-disable no-param-reassign */
import React from 'react';
import { Input, Button, notification, Popover, InputNumber } from 'antd';
import { sortBy } from 'lodash';

const CHECK_OBJECT = {
  supplyPrice: '供货价',
  marketPrice: '市场价',
  productStock: '库存',
  thirdSkuNo: '商品自编码',
};

export function normFile(fileList) {
  return fileList;
}
export function specValidate(editArr, initArr, isEdit, msg) {
  let isSame = false;
  if (editArr && editArr.length) {
    const list = isEdit ? editArr.concat(initArr) : editArr;
    list.forEach((i, index) => {
      const index1 = list.indexOf(i);
      if (index1 !== index) {
        isSame = true;
      }
    });
  }
  if (isSame && msg) {
    notification.error({
      message: msg,
    });
  }
  return isSame;
}

export function createNewList(first, second, firstSpecId, secondSpecId) {
  const list = [];
  const sku = {
    weight: '',
    productStockWarning: '',
    marketPrice: '',
    // salePrice: '',
    supplyPrice: '',
    // stock: '',
    productStock: '',
    thirdSkuNo: '',
    skuLink: '',
    imageList: [],
  };
  if (first && first.length) {
    // 一级规格有值时，生成的编辑表格
    first.forEach(fir => {
      const copy = Object.assign({}, sku);
      copy.firstSpecId = firstSpecId;
      copy.firstSpecValue = fir;
      if (second.length) {
        second.forEach(sec => {
          const copySec = Object.assign({}, copy);
          copySec.secondSpecId = secondSpecId;
          copySec.secondSpecValue = sec;
          list.push(copySec);
        });
        return;
      }
      console.log(copy);
      list.push(copy);
    });
  } else if (second.length) {
    // 缺少一级规格值，只有二级规格值时，生成的编辑表格
    second.forEach(sec => {
      const copy = Object.assign({}, sku);
      copy.secondSpecId = secondSpecId;
      copy.secondSpecValue = sec;
      list.push(copy);
    });
  } else {
    // 缺少一级和二级规格时生成的编辑表格
    list.push(sku);
  }
  console.log(list);
  return list;
}

export function createEditData(values, initData) {
  let list = null;
  const first = values.first?.filter(item => item && !item.match(/^[ ]*$/)) || [];
  const second =
    (values.second && values.second.filter(item => item && !item.match(/^[ ]*$/))) || [];

  const newFirst = first.concat(initData.firstSpecList || []);
  const isFirstSame = specValidate(
    first,
    initData.firstSpecList,
    initData.id,
    '一级规格值不可重复',
  );
  const isSecondSame = specValidate(
    second,
    initData.secondSpecList,
    initData.id,
    '二级规格值不可重复',
  );
  if (!isFirstSame && !isSecondSame) {
    if (!initData.id) {
      list = createNewList(first, second, values.firstSpecId, values.secondSpecId);
      // this.setState({ editData: list });
    } else {
      const list1 = first.length
        ? createNewList(first, initData.secondSpecList, values.firstSpecId, values.secondSpecId)
        : [];
      const list2 = second.length
        ? createNewList(newFirst, second, values.firstSpecId, values.secondSpecId)
        : [];

      // 初次添加规格时没有选择规格，添加一条没有规格的商品，被驳回之后编辑时选择规格之后需要重新创建
      // 编辑时回显时的id需要给重新创建的数据第一条加上 回显的id
      if (!initData.editData[0]?.firstSpec && !initData.editData[0]?.secondSpec) {
        list = createNewList(first, second, values.firstSpecId, values.secondSpecId);
        // 这种情况出现时items中只有一条数据
        // 第一次无规格时，重新生成的数据，必须保留第一条数据的id是items里面第一条数据的id
        list[0].id = initData.editData[0].id;
      } else {
        list = sortBy(initData.editData.concat(list1.concat(list2)), item => item.firstSpecValue);
      }
    }
  }
  return list;
}

export function validateSpuInfo(values, initData, editData, productType) {
  const newCheckObject =
    productType === 1 ? { ...CHECK_OBJECT, weight: '重量(kg)' } : { ...CHECK_OBJECT };
  const checkKey = Object.keys(newCheckObject);
  const checkString = [];
  editData.forEach((item, index) => {
    const rowCheckString = checkKey.reduce((checkMessage, val, ind) => {
      const checkItem = item[val];
      if (checkItem === null || checkItem === undefined || checkItem === '') {
        checkMessage += `${newCheckObject[val]}; `;
      }
      return checkMessage;
    }, '');
    if (rowCheckString) {
      checkString.push(<div key={index.toString()}>{`第${index + 1}行: ${rowCheckString}`}</div>);
    }
  });
  if (checkString.length) {
    notification.warning({
      message: '请完善表格:',
      description: checkString,
      duration: null,
    });
    return true;
  }
  return false;
}

export function dataInit(list) {
  if (!list || !list.length) return;
  const obj = {};
  let finialList = [];
  list.forEach(item => {
    obj[item.firstSpecValue] = [];
  });
  list.forEach(item => obj[item.firstSpecValue].push(item));
  const keys = Object.keys(obj);
  keys.forEach(key => {
    obj[key].forEach((i, index) => {
      if (index === 0) {
        i.length = obj[key].length;
      }
    });
    finialList = finialList.concat(obj[key]);
    return finialList;
  });
}

export function verify(initData, categoryId) {
  if (categoryId || (initData && initData.thirdCategoryId)) {
    return true;
  }
  notification.error({
    message: '请选择三级类目',
  });
  return false;
}

export function editColumns(methods, firstData, firstSpec, secondSpec, isJDGoods, isEdit) {
  const { getJdPicList, inputChange, openModal, productType } = methods;
  if (!firstData) return [];

  const arr = [
    {
      title: '供货价',
      align: 'center',
      key: 'supplyPrice',
      dataIndex: 'supplyPrice',
      width: 100,
      render: (val, row, index) => (
        <InputNumber
          defaultValue={val}
          value={val}
          precision={2}
          min={0}
          onChange={value => inputChange(value, 'supplyPrice', index)}
          disabled={isJDGoods}
        />
      ),
    },
    {
      title: '市场价',
      align: 'center',
      key: 'marketPrice',
      dataIndex: 'marketPrice',
      width: 100,
      render: (val, row, index) => (
        <InputNumber
          defaultValue={val}
          value={val}
          precision={2}
          min={0}
          onChange={value => inputChange(value, 'marketPrice', index)}
        />
      ),
    },
    {
      title: '库存',
      align: 'center',
      key: 'productStock',
      dataIndex: 'productStock',
      width: 100,
      render: (val, row, index) => (
        <InputNumber
          value={val}
          precision={0}
          min={0}
          onChange={value => inputChange(value, 'productStock', index)}
        />
      ),
    },
    {
      title: '商品自编码',
      align: 'center',
      key: 'thirdSkuNo',
      dataIndex: 'thirdSkuNo',
      width: 100,
      render: (val, row, index) => (
        <Input
          value={val}
          className={`thirdSkuNo ${index}`}
          defaultValue={val}
          onChange={evt => inputChange(evt.target.value, 'thirdSkuNo', index)}
        />
      ),
    },
    {
      title: '京东链接',
      align: 'center',
      key: 'skuLink',
      dataIndex: 'skuLink',
      width: 80,
      render: (val, row, index) => (
        <Popover content={val} trigger="hover">
          {
            <Input
              value={val}
              className={`skuLink ${index}`}
              defaultValue={val}
              onChange={evt => inputChange(evt.target.value, 'skuLink', index)}
            />
          }
        </Popover>
      ),
    },
    {
      title: '操作',
      align: 'center',
      key: 'option',
      dataIndex: 'option',
      width: 100,
      render: (_, row, index) => (
        <div>
          {row.skuLink && (
            <Button type="primary" size="small" onClick={() => getJdPicList(row)}>
              拉图片
            </Button>
          )}
          {isJDGoods && (
            <Button
              type="primary"
              size="small"
              style={{ marginTop: '5px' }}
              onClick={() => openModal(row, index)}
            >
              修改sku名称
            </Button>
          )}
        </div>
      ),
    },
  ];
  if (productType === 1) {
    // 如果是实体商品添加重量
    arr.splice(2, 0, {
      title: '重量(kg)',
      align: 'center',
      key: 'weight',
      dataIndex: 'weight',
      width: 120,
      render: (val, row, index) => (
        <InputNumber
          style={{ width: '100%' }}
          value={val}
          min={0}
          max={999999.999}
          precision={3}
          onChange={value => inputChange(value, 'weight', index)}
        />
      ),
    });
    arr.splice(4, 0, {
      title: '库存预警',
      align: 'center',
      key: 'productStockWarning',
      dataIndex: 'productStockWarning',
      width: 90,
      render: (val, row, index) => (
        <InputNumber
          defaultValue={0}
          value={val}
          maxLength={5}
          min={0}
          precision={0}
          onChange={value => inputChange(value, 'productStockWarning', index)}
        />
      ),
    });
  }

  if (secondSpec && firstData.secondSpecValue) {
    arr.unshift({
      title: secondSpec,
      align: 'center',
      key: 'secondSpecValue',
      dataIndex: 'secondSpecValue',
      width: 100,
    });
  }

  if (firstSpec && firstData.firstSpecValue) {
    arr.unshift({
      title: firstSpec,
      dataIndex: 'firstSpecValue',
      key: 'firstSpecValue',
      align: 'center',
      width: 100,
      render: (val, row) => {
        const obj = {
          children: val,
          props: {},
        };
        if (row.length) {
          obj.props.rowSpan = row.length;
        } else {
          obj.props.rowSpan = 0;
        }
        return obj;
      },
    });
  }
  if (isEdit && isJDGoods) {
    arr.splice(arr.length - 1, 0, {
      title: 'sku名称',
      align: 'center',
      key: 'name',
      dataIndex: 'name',
      width: 100,
      render: val => (
        <Popover content={val} trigger="hover">
          <a>查看名称</a>
        </Popover>
      ),
    });
  }
  return arr;
}

export const goodsType = [
  {
    name: '普通商品',
    value: 1,
  },
  {
    name: '虚拟商品',
    value: 2,
  },
  {
    name: '电子卡券',
    value: 3,
  },
];
