export default {
  get(key) {
    let result = sessionStorage.getItem(key);
    try {
      result = JSON.parse(result);
    } catch {
      console.log(); // eslint-disable-line no-console
    }
    return result;
  },
  set(key, value) {
    const { toString } = Object.prototype;
    if (toString.call(value) === '[object Array]' || toString.call(value) === '[object Object]') {
      value = JSON.stringify(value); // eslint-disable-line no-param-reassign
    }
    return sessionStorage.setItem(key, value);
  },
  remove(key) {
    return sessionStorage.removeItem(key);
  },
  clear() {
    return sessionStorage.clear();
  },
};
