import React from 'react';
import { Table, Form, InputNumber, Input, Popconfirm } from 'antd';

const data = [];
// eslint-disable-next-line no-plusplus
for (let i = 0; i < 5; i++) {
  data.push({
    firstSpecValue: '规格一级',
    secondSpecValue: '规格二级',
    key: i.toString(),
    name: `Edrward ${i}`,
    age: 32,
    address: `London Park no. ${i}`,
  });
}

const EditableContext = React.createContext();

const EditableCell = tableProps => {
  const getInput = () => {
    if (tableProps.inputType === 'number') {
      return <InputNumber />;
    }
    return <Input />;
  };
  const renderCell = form => {
    const { getFieldDecorator } = form;
    const {
      editing,
      dataIndex,
      title,
      inputType,
      record,
      index,
      children,
      ...restProps
    } = tableProps;
    return (
      <td {...restProps}>
        {editing ? (
          <Form.Item style={{ margin: 0 }}>
            {getFieldDecorator(`tableArray[${record.key}][${dataIndex}]`, {
              rules: [
                {
                  required: true,
                  message: `Please Input ${title}!`,
                },
              ],
              initialValue: record[dataIndex],
            })(getInput())}
          </Form.Item>
        ) : (
          children
        )}
      </td>
    );
  };
  return <EditableContext.Consumer>{renderCell}</EditableContext.Consumer>;
};

const isEditing = record => record.key === '';

const ProductInfoColumns = () => [
  {
    title: '一级规格',
    dataIndex: 'firstSpecValue',
    editable: false,
  },
  {
    title: '二级规格',
    dataIndex: 'secondSpecValue',
    editable: false,
  },
  {
    title: 'name',
    dataIndex: 'name',
    editable: true,
  },
  {
    title: 'age',
    dataIndex: 'age',
    editable: true,
  },
  {
    title: 'address',
    dataIndex: 'address',
    editable: true,
  },
  {
    title: 'operation',
    dataIndex: 'operation',
    render: (text, record) => {
      const editingKey = '';
      const editable = isEditing(record);
      return editable ? (
        <span>
          <EditableContext.Consumer>
            {form => (
              <a
                // onClick={() => save(form, record.key)}
                style={{ marginRight: 8 }}
              >
                Save
              </a>
            )}
          </EditableContext.Consumer>
          <Popconfirm title="Sure to cancel?">
            <a>Cancel</a>
          </Popconfirm>
        </span>
      ) : (
        <a disabled={editingKey !== ''}>Edit</a>
      );
    },
  },
];

export const GenerateProductInfo = ({ form }) => {
  const components = {
    body: {
      cell: EditableCell,
    },
  };

  const columns = ProductInfoColumns().map(col => {
    if (!col.editable) {
      return col;
    }
    return {
      ...col,
      onCell: record => ({
        record,
        inputType: col.dataIndex === 'age' ? 'number' : 'text',
        dataIndex: col.dataIndex,
        title: col.title,
        editing: true,
      }),
    };
  });

  return (
    <EditableContext.Provider value={form}>
      <Table
        pagination={false}
        components={components}
        bordered
        dataSource={data}
        columns={columns}
        rowClassName="editable-row"
      />
    </EditableContext.Provider>
  );
};
