import * as api from './service';

const Model = {
  namespace: 'goodsManage',
  state: {
    tableData: {},
    shopList: [],
    statusList: [],
    cid1List: [],
    cid2List: [],
    cid3List: [],
    treeData: [],
  },
  effects: {
    *getList({ payload }, { call, put }) {
      const params = payload;
      const productCategoryId = payload?.productCategoryId || [];
      params.productCategoryId =
        (productCategoryId.length && productCategoryId[productCategoryId.length - 1]) || '';
      const { data } = yield call(api.searchList, params);
      if (!data) return;
      yield put({
        type: 'saveData',
        payload: {
          tableData: data,
        },
      });
    },
    *getDataList({ payload }, { call, put, all }) {
      const [[shopList], [statusList]] = yield all([
        yield call(api.shopList, payload),
        yield call(api.statusList, payload),
      ]);
      if (!shopList && !statusList) return;
      yield put({
        type: 'dataList',
        payload: {
          shopList,
          statusList,
        },
      });
    },
    *categoryList({ payload }, { call, put }) {
      const [data] = yield call(api.categoryList, payload.value);
      if (!data) return;
      yield put({
        type: 'saveCategory',
        payload: {
          [payload.categoryNum]: data,
        },
      });
    },
  },
  reducers: {
    saveData(state, action) {
      const data = action.payload;
      return { ...state, ...data };
    },
    dataList(state, action) {
      const data = action.payload;
      return { ...state, ...data };
    },
    saveCategory(state, action) {
      const data = action.payload;
      return { ...state, ...data };
    },
  },
};
export default Model;
