import { Modal, InputNumber, notification } from 'antd';
import React, { useState, useEffect } from 'react';
import { updatePrice } from '../service';
import styles from './style.less';

export default function UpdatePrice(props) {
  const [visible, setVisible] = useState(props.visible);
  const [supplyPrice, setSupplyPrice] = useState(props.info.supplyPrice);
  const [marketPrice, setMarketPrice] = useState(props.info.marketPrice);
  // const [salePrice, setSalePrice] = useState(props.info.salePrice);

  useEffect(() => {
    setVisible(props.visible);
    setSupplyPrice(props.info.supplyPrice);
    setMarketPrice(props.info.marketPrice);
    // setSalePrice(props.info.salePrice);
  }, [props]);

  const submit = async () => {
    if (!supplyPrice || !marketPrice) {
      notification.error({ message: '价格不可为空!' });
      return;
    }
    const error = await updatePrice({
      // salePrice,
      supplyPrice,
      marketPrice,
      id: props.info.id,
      supplierId: props.info.supplierId,
    });
    if (!error) {
      notification.success({ message: '修改成功' });
      props.onCancel('success');
    }
  };
  return (
    <Modal
      title="修改价格"
      visible={visible}
      onCancel={() => props.onCancel()}
      onOk={submit}
      width={400}
    >
      <div className={styles.center}>
        供货价：
        <InputNumber
          min={0}
          precision={2}
          value={supplyPrice}
          onChange={value => setSupplyPrice(value)}
          className={styles.inputNW}
        />
        <br />
        <br />
        市场价：
        <InputNumber
          min={0}
          precision={2}
          value={marketPrice}
          onChange={value => setMarketPrice(value)}
          className={styles.inputNW}
        />
        <br />
        <br />
        {/* 销售价：
        <InputNumber
          min={0}
          precision={2}
          value={salePrice}
          onChange={value => setSalePrice(value)}
          className={styles.inputNW}
        /> */}
      </div>
    </Modal>
  );
}
