import React, { useState } from 'react';
import ProTable from '@ant-design/pro-table';
import { PageHeaderWrapper } from '@ant-design/pro-layout';
// import { FormInstance } from 'antd/lib/form';
import { notification } from 'antd';
import Detail from '../components/detail';
import ImgModal from '../components/imgModal';
import styles from './styles.less';
import { columns } from './staticdata';
import { query, getDetail } from './services';
import AuditModal from '../components/audit';

const Appeal = () => {
  // const protable = useRef();
  // const ref = useRef(FormInstance);
  const [detailModal, changeDetailModal] = useState(false);
  const [auditModal, changeAuditModal] = useState(false);
  const [imgModal, changeImgModal] = useState(false);
  const [selectedRow, getRow] = useState({});
  const [imgData, getImgData] = useState([]);
  const [imgTitle, changeImgTitle] = useState('');

  const openDetail = async row => {
    const detailData = await getDetail({ appealNo: row.appealNo });
    changeDetailModal(true);
    getRow(detailData);
  };

  const openAudit = async row => {
    const detailData = await getDetail({ appealNo: row.appealNo });
    getRow(detailData);
    changeAuditModal(true);
  };
  const openImgModal = imgList => {
    if (!imgList.length) {
      notification.error({
        message: '啊哦～没有数据！',
      });
      return;
    }
    // const list = ['https://www.baidu.com/img/flexible/logo/pc/result@2.png'];
    getImgData(imgList);
    changeImgModal(true);
    changeImgTitle('查看图片');
  };
  const closeModal = params => {
    if (params === 'Detail') {
      changeDetailModal(false);
      return;
    }
    if (params === 'Audit') {
      changeAuditModal(false);
      return;
    }
    changeImgModal(false);
  };
  const res = {
    // handleAudit,
    openAudit,
    openDetail,
    openImgModal,
  };

  return (
    <PageHeaderWrapper>
      <ProTable
        search={{
          collapsed: false,
          collapseRender: () => null,
        }}
        columns={columns(res)}
        request={params => query({ ...params })}
        rowKey={r => r.appealNo}
        expandIconColumnIndex={10}
        bordered
        className={styles.table}
        toolBarRender={false}
        scroll={{ x: '100%' }}
      />
      <Detail
        data={selectedRow}
        modalVisible={detailModal}
        onCancel={() => closeModal('Detail')}
      ></Detail>
      <AuditModal
        data={selectedRow}
        modalVisible={auditModal}
        onCancel={() => closeModal('Audit')}
      ></AuditModal>
      <ImgModal
        imgData={imgData}
        modalVisible={imgModal}
        title={imgTitle}
        onCancel={() => closeModal('imgModal')}
      ></ImgModal>
    </PageHeaderWrapper>
  );
};
export default Appeal;
