import React, { useEffect } from 'react';
import { Form, InputNumber, Modal, notification } from 'antd';
import { layout } from '../staticData/goods';
import { apiMealInfoUpdate } from '../service';

const SaleDateModal = props => {
  const [form] = Form.useForm();

  // 关闭弹窗
  const handleCancel = () => {
    props.handleClose(false);
  };

  // 提交
  const handleConfirm = async () => {
    const res = await form.validateFields();
    console.log('res :>> ', res);
    const params = {
      id: props.id,
      sort: res.sort,
    };
    await apiMealInfoUpdate(params);
    notification.success({ message: '保存成功' });
    handleCancel();
    props.handleRefresh();
  };

  useEffect(() => {
    if (props.visible) {
      form.setFieldsValue({ sort: null });
    }
  }, [props.visible]);

  return (
    <Modal
      title="修改商品排序"
      open={props.visible}
      destroyOnClose
      maskClosable={false}
      width="300px"
      okText="保存"
      onOk={handleConfirm}
      onCancel={handleCancel}
    >
      <Form name="basicInfo" initialValues={{ sort: 1000 }} {...layout} form={form}>
        <Form.Item label="排序" name="sort" rules={[{ required: true, message: '请输入排序!' }]}>
          <InputNumber max={999999} min={1} />
        </Form.Item>
      </Form>
    </Modal>
  );
};
export default SaleDateModal;
