/* eslint-disable no-console */
import * as Sentry from '@sentry/react';
import localStorage from '@/utils/localStorage';

if (process.env.NODE_ENV === 'production') {
  try {
    Sentry.init({
      dsn: 'http://b3f60c62e1234e26a5b851b9f26fba07@sentry.q-gp.com/34',
      release: 'merchant-manage-ui@1.0.0',
      maxBreadcrumbs: 50,
      tracesSampleRate: 1,
    });
    Sentry.configureScope(scope => {
      scope.setUser({
        token: localStorage.get('token') || null,
      });
    });
  } catch (e) {
    console.log('Sentry无法加载', e);
  }
}

export const dva = {
  config: {
    onError(e) {
      e.preventDefault();
      console.error(e.message);
    },
  },
};
