import slash from 'slash2';
import defaultSettings from './defaultSettings'; // https://umijs.org/config/
import webpackPlugin from './plugin.config';
import groupMealRoute from './groupMealRoute';

const { pwa, primaryColor } = defaultSettings; // preview.pro.ant.design only do not use in your production ;
// preview.pro.ant.design 专用环境变量，请不要在你的项目中使用它。

const { ANT_DESIGN_PRO_ONLY_DO_NOT_USE_IN_YOUR_PRODUCTION } = process.env;
const isAntDesignProPreview = ANT_DESIGN_PRO_ONLY_DO_NOT_USE_IN_YOUR_PRODUCTION === 'site';
const plugins = [
  [
    'umi-plugin-react',
    {
      antd: true,
      dva: {
        hmr: true,
      },
      locale: {
        // default false
        enable: true,
        // default zh-CN
        default: 'zh-CN',
        // default true, when it is true, will use `navigator.language` overwrite default
        baseNavigator: true,
      },
      // dynamicImport: {
      //   loadingComponent: './components/PageLoading/index',
      //   webpackChunkName: true,
      //   level: 3,
      // },
      pwa: false,
      // default close dll, because issue https://github.com/ant-design/ant-design-pro/issues/4665
      // dll features https://webpack.js.org/plugins/dll-plugin/
      // dll: {
      //   include: ['dva', 'dva/router', 'dva/saga', 'dva/fetch'],
      //   exclude: ['@babel/runtime', 'netlify-lambda'],
      // },
    },
  ],
  [
    'umi-plugin-pro-block',
    {
      moveMock: false,
      moveService: false,
      modifyRequest: true,
      autoAddMenu: true,
    },
  ],
];

export default {
  antd: {},
  dva: {
    hmr: true,
  },
  hash: true,
  locale: {
    default: 'zh-CN', //开启国际化配置，就必须要创建locales/zh-CN.ts 文件
    baseNavigator: true,
  },
  targets: {
    ie: 11,
  },
  // devtool: process.env.SENTRY_ENV === 'test' ? false : 'hidden-source-map',
  devtool: false,
  // umi routes: https://umijs.org/zh/guide/router.html
  routes: [
    {
      path: '/user',
      component: '../layouts/UserLayout',
      routes: [
        {
          name: 'login',
          path: '/user/login',
          component: './user/login',
        },
      ],
    },
    {
      path: '/',
      component: '../layouts/SecurityLayout',
      title: '商户管理后台',
      routes: [
        {
          path: '/',
          component: '../layouts/BasicLayout',
          authority: ['Admin', 'user'],
          routes: [
            {
              title: '首页',
              path: '/',
              component: './Admin',
            },
            {
              title: '商户管理后台',
              path: '/orderManage/queryOrder',
              name: 'queryOrder',
              component: './orderManage/queryOrder',
            },
            {
              title: '商户管理后台',
              path: '/orderManage/pendingDeliveryOrder',
              name: 'pendingDeliveryOrder',
              component: './orderManage/pendingDeliveryOrder',
            },
            {
              title: '商户管理后台',
              path: '/orderManage/deliveryOrder',
              name: 'deliveryOrder',
              component: './orderManage/deliveryOrder',
            },
            {
              title: '商户管理后台',
              path: '/orderManage/batchDelivery',
              name: 'batchDeliveryOrder',
              component: './orderManage/batchDelivery',
            },
            {
              title: '商户管理后台',
              path: '/afterSaleAddress',
              name: 'afterSaleAddress',
              component: './afterSaleAddress',
            },
            {
              title: '商户管理后台',
              path: '/reconciliation',
              name: 'reconciliation',
              component: './reconciliation',
            },
            {
              title: '商户管理后台',
              path: '/reconciliation/detail',
              name: 'reconciliationDetail',
              component: './reconciliation/detail/index',
            },
            {
              title: '商户管理后台',
              path: '/settleManage',
              name: 'settleManage',
              component: './settleManage',
            },
            {
              title: '商户管理后台',
              path: '/afterSaleManage',
              name: 'afterSaleManage',
              icon: 'smile',
              component: './AfterSaleManage/index',
            },
            {
              title: '商户管理后台',
              path: '/afterSalesClaimForm',
              name: 'afterSalesClaimForm',
              icon: 'smile',
              component: './AfterSalesClaimForm/index',
            },
            {
              title: '商户管理后台',
              path: '/afterSaleManageOld',
              name: 'afterSaleManageOld',
              icon: 'smile',
              component: './AfterSaleManageOld/index',
            },
            {
              title: '商户管理后台',
              path: '/auditPending',
              name: 'auditPending',
              icon: 'smile',
              component: './AfterSaleManageOld/Pending',
            },
            {
              title: '商户管理后台',
              path: '/passAudit',
              name: 'passAudit',
              icon: 'smile',
              component: './AfterSaleManageOld/PassAudit',
            },
            {
              title: '商户管理后台',
              path: '/appeal',
              name: 'appeal',
              component: './afterSale/appeal',
            },
            {
              title: '商户管理后台',
              path: '/cancelBillManage',
              name: 'cancelBillManage',
              component: './cancelBillManage',
            },
            {
              title: '商户管理后台',
              path: '/goodsManage',
              name: 'goodsManage',
              icon: 'smile',
              component: './GoodsManage',
            },
            {
              path: '/distributionArea',
              name: 'distributionArea',
              icon: 'smile',
              component: './distributionArea',
            },
            {
              title: '商户管理后台',
              path: '/reconciliationQuery',
              name: 'reconciliationQuery',
              icon: 'smile',
              component: './ReconciliationQuery',
            },
            {
              title: '商户管理后台',
              path: '/settlementSheet',
              name: 'settlementSheet',
              icon: 'smile',
              component: './SettlementSheet',
            },
            {
              title: '商户管理后台',
              path: '/paymentMange',
              name: 'paymentMange',
              icon: 'smile',
              component: './PaymentMange',
            },
            {
              path: '/password',
              name: 'password',
              icon: 'smile',
              component: './password',
            },
            {
              path: '/chainStoreManage',
              name: 'chainStoreManage',
              icon: 'smile',
              component: './chainStoreManage',
            },
            // {
            //   path: '/GoodsManage-new',
            //   name: 'GoodsManageNew',
            //   component: './GoodsManage-new',
            // },
            {
              title: '服务商品改造-商品模块',
              path: '/ServiceGoods/:id',
              name: 'ServiceGoods',
              component: './ServiceGoods/index',
            },
            {
              title: '商户管理后台-账号管理',
              path: '/systemManage/account',
              name: 'systemManageAccount',
              component: './systemManage/Account',
            },
            {
              title: '商户管理后台-账号管理-用户信息',
              path: '/systemManage/account/userInfo',
              name: 'accountUserInfo',
              component: './systemManage/Account/UserInfo',
            },
            {
              title: '商户管理后台-角色管理',
              path: '/systemManage/role',
              name: 'systemManageRole',
              component: './systemManage/Role',
            },
            {
              title: '商户管理后台-角色管理-角色信息',
              path: '/systemManage/role/roleInfo',
              name: 'roleInfo',
              component: './systemManage/Role/RoleInfo',
            },
            {
              title: '商户管理后台-日志管理',
              path: '/systemManage/log',
              name: 'systemManageLog',
              component: './systemManage/Log',
            },
            {
              title: '商户管理后台-合同查看',
              path: '/contractView',
              name: 'contractView',
              component: './contractView',
            },
            {
              title: '商户管理后台-商家资料',
              path: '/businessInfo',
              name: 'businessInfo',
              component: './businessManage/info',
            },
            ...groupMealRoute,
            {
              component: './404',
            },
          ],
        },
        {
          component: './404',
        },
      ],
    },
    {
      component: './404',
    },
  ],
  // Theme for antd: https://ant.design/docs/react/customize-theme-cn
  theme: {
    'primary-color': primaryColor,
  },
  define: {
    'process.env.PRE_ENV': process.env.PRE_ENV,
    'process.env.SENTRY_ENV': process.env.SENTRY_ENV,
    ANT_DESIGN_PRO_ONLY_DO_NOT_USE_IN_YOUR_PRODUCTION:
      ANT_DESIGN_PRO_ONLY_DO_NOT_USE_IN_YOUR_PRODUCTION || '', // preview.pro.ant.design only do not use in your production ; preview.pro.ant.design 专用环境变量，请不要在你的项目中使用它。
  },
  ignoreMomentLocale: true,
  lessLoader: {
    javascriptEnabled: true,
  },
  cssLoader: {
    modules: {
      getLocalIdent: (context, _, localName) => {
        if (
          context.resourcePath.includes('node_modules') ||
          context.resourcePath.includes('ant.design.pro.less') ||
          context.resourcePath.includes('global.less')
        ) {
          return localName;
        }

        const match = context.resourcePath.match(/src(.*)/);

        if (match && match[1]) {
          const antdProPath = match[1].replace('.less', '');
          const arr = slash(antdProPath)
            .split('/')
            .map(a => a.replace(/([A-Z])/g, '-$1'))
            .map(a => a.toLowerCase());
          return `antd-pro${arr.join('-')}-${localName}`.replace(/--/g, '-');
        }

        return localName;
      },
    },
  },
  chainWebpack: webpackPlugin,
  /*
  proxy: {
    '/server/api/': {
      target: 'https://preview.pro.ant.design/',
      changeOrigin: true,
      pathRewrite: { '^/server': '' },
    },
  },
  */
};
