import React from 'react';
import { Form, Modal, Input, Checkbox, Alert } from 'antd';

const GroupInfo = options => {
  const [form] = Form.useForm();

  // 关闭分组信息弹窗
  const handleCancel = () => {
    options.handleClose(false);
  };

  // 提交分组
  const handleConfirm = async () => {
    const values = await form.validateFields();
    console.log('values :>> ', values);
    handleCancel();
  };

  const extra = (
    <Alert
      message="选中后，顾客下单需至少选择1个“下单必选分组”商品每店仅可设置1个必点分组"
      type="error"
    />
  );

  return (
    <Modal
      title="分组信息"
      visible={options.isModalOpen}
      onOk={handleConfirm}
      onCancel={handleCancel}
    >
      <Form name="basic" form={form} labelCol={{ span: 6 }} wrapperCol={{ span: 16 }}>
        <Form.Item
          label="分组名称"
          name="name"
          rules={[{ required: true, message: '请输入分组名称!' }]}
        >
          <Input />
        </Form.Item>

        <Form.Item label="下单必选分组" name="necessary" extra={extra}>
          <Checkbox />
        </Form.Item>
      </Form>
    </Modal>
  );
};

export default GroupInfo;
