import React, { useState, useEffect, useCallback, useMemo } from 'react';
import { Spin, Table, Modal, message, notification } from 'antd';
import { MenuOutlined, HolderOutlined, FormOutlined, CloseCircleOutlined } from '@ant-design/icons';
import { SortableContainer, SortableElement, SortableHandle } from 'react-sortable-hoc';
import { arrayMoveImmutable } from 'array-move';
import GoodsGroup from './components/GoodsGroup';
import { searchList, apiGoodsActionBatch } from '../service';
import styles from '../style.less';
import { takeawayColumn } from '../staticdata';
// import VirtualTable from './components/VirtualTable';
import ActionBar from './components/ActionBar';
import WeekTime from './components/WeekTime';
import StockModal from './components/StockModal';
import SendModal from './components/SendModal';
import MinimumPurchaseModal from './components/MinimumPurchase';
import SwitchGroupModal from './components/SwitchGroupModal';

const Takeaway = options => {
  const [tableData, setTableData] = useState([]);
  const [selectedRowKeys, setSelectedRowKeys] = useState([]);
  const [shopId, setShopId] = useState(0);
  const [loading, setLoading] = useState(false);
  const [actionLoading, setActionLoading] = useState(false);
  const [visibleWeekTime, setVisibleWeekTime] = useState(false);
  const [visibleStock, setVisibleStock] = useState(false);
  const [visibleBuy, setVisibleBuy] = useState(false);
  const [visibleSend, setVisibleSend] = useState(false);
  const [visibleSwitchGroup, setVisibleSwitchGroup] = useState(false);

  const rowSelection = {
    selectedRowKeys,
    onChange: setSelectedRowKeys,
  };

  const onSortEnd = ({ oldIndex, newIndex }) => {
    if (oldIndex !== newIndex) {
      const newData = arrayMoveImmutable(tableData.slice(), oldIndex, newIndex).filter(el => !!el);
      setTableData(newData);
    }
  };

  const SortableItem = SortableElement(props => <tr {...props} />);
  const SortableBody = SortableContainer(props => <tbody {...props} />);

  const DraggableContainer = props => (
    <SortableBody
      useDragHandle
      disableAutoscroll
      helperClass={styles['row-dragging']}
      onSortEnd={onSortEnd}
      {...props}
    />
  );

  const DraggableBodyRow = ({ className, style, ...restProps }) => {
    // function findIndex base on Table rowKey props and should always be a right array index
    const index = tableData.findIndex(x => x.skuId === restProps['data-row-key']);
    return <SortableItem index={index} {...restProps} />;
  };

  const getDataList = async () => {
    setLoading(true);
    const res = await searchList({ productType: 1 });
    setLoading(false);
    if (res && res.data) {
      setTableData(res.data.records);
    }
  };

  // 批量操作 type 1-是否列出 2-修改上下架   3-改货架  4-售卖时间更新  5-调整商品起购数量 6-调整商品是否单点不送   7-修改库存
  const handleBatchAction = async params => {
    const json = {
      skuIds: selectedRowKeys,
      shopId,
    };
    // setActionLoading(true);
    // const params2 = {
    //   ...json,
    //   ...params,
    // };
    // console.log('params2 :>> ', params2);
    // const res = await apiGoodsActionBatch(Object.assign({}, json, params));
    // setActionLoading(false);
    // getDataList();
    message.success('处理成功！');
  };

  // 显示弹窗
  const openModal = type => {
    type === 'time' && setVisibleWeekTime(true);
    type === 'stock' && setVisibleStock(true);
    type === 'group' && setVisibleSwitchGroup(true);
    type === 'buy' && setVisibleBuy(true);
    type === 'send' && setVisibleSend(true);
  };

  // 单商品修改库存
  const onShowStockModal = ({ skuId }) => {
    setSelectedRowKeys([skuId]);
    openModal('stock');
  };
  // 编辑
  const onEdit = row => {};
  // 置顶
  const toTop = row => {};

  useEffect(() => {
    getDataList();
  }, []);

  const actions = {
    onShowStockModal,
    toTop,
    onEdit,
  };

  return (
    <div className={styles.takeawayBox}>
      <Spin spinning={loading}>
        <GoodsGroup changeShop={setShopId} />
        <ActionBar
          selectedRowKeys={selectedRowKeys}
          handleSearch={getDataList}
          openModal={openModal}
        />
        <Table
          dataSource={tableData}
          bordered
          columns={takeawayColumn(actions)}
          rowKey={record => record.skuId}
          pagination={false}
          scroll={{ x: '100%', y: 1000 }}
          rowSelection={rowSelection}
          components={{
            body: {
              wrapper: DraggableContainer,
              row: DraggableBodyRow,
            },
          }}
        />
      </Spin>
      <WeekTime
        visible={visibleWeekTime}
        loading={actionLoading}
        confirm={handleBatchAction}
        cancel={setVisibleWeekTime}
      />
      <StockModal
        visible={visibleStock}
        loading={actionLoading}
        confirm={handleBatchAction}
        cancel={setVisibleStock}
      />
      <SendModal
        visible={visibleSend}
        loading={actionLoading}
        confirm={handleBatchAction}
        cancel={setVisibleSend}
      />
      <MinimumPurchaseModal
        visible={visibleBuy}
        loading={actionLoading}
        confirm={handleBatchAction}
        cancel={setVisibleBuy}
      />
      <SwitchGroupModal
        visible={visibleSwitchGroup}
        loading={actionLoading}
        confirm={handleBatchAction}
        cancel={setVisibleSwitchGroup}
      />
    </div>
  );
};

export default Takeaway;
