import React, { useState } from 'react';
import { Button, Select, Tag } from 'antd';
import { DndProvider } from 'react-dnd';
import HTML5Backend from 'react-dnd-html5-backend';
import styles from '../../style.less';
import DragTag from './DragTag';
import InsertTag from './InsertTag';
import GroupInfo from './GroupInfo';

const GoodsGroup = options => {
  const [groupEdit, setGroupEdit] = useState(false);
  const [selected, setSelected] = useState(0);
  const [isModalOpen, setIsModalOpen] = useState(false);
  const [shops, setShops] = useState([]);

  const [tags, setTags] = useState([
    {
      id: 0,
      text: '000',
    },
    {
      id: 1,
      text: '111',
    },
    {
      id: 2,
      text: '000',
    },
    {
      id: 3,
      text: '111',
    },
    {
      id: 4,
      text: '000',
    },
    {
      id: 5,
      text: '111',
    },
  ]);

  // 更换位置
  const changePosition = (dragIndex, hoverIndex) => {
    const data = tags.slice();
    const temp = data[dragIndex];
    // 交换位置
    data[dragIndex] = data[hoverIndex];
    data[hoverIndex] = temp;
    setTags(data);
  };

  return (
    <div className={styles.groupBox}>
      <div className={styles['groupBox-title']}>
        <div className={styles['groupBox-title--name']}>所属门店</div>
        <Select
          showSearch
          placeholder="请选择所属门店"
          onChange={options.changeShop}
          filterOption={(input, option) =>
            (option?.label ?? '').toLowerCase().includes(input.toLowerCase())
          }
          options={shops}
        />
      </div>
      <div className={styles['groupBox-title']}>
        <div className={styles['groupBox-title--name']}>商品分组</div>
        <Button onClick={() => setGroupEdit(!groupEdit)}>{groupEdit ? '完成' : '编辑分组'}</Button>
      </div>
      <div className={styles['groupBox-body']}>
        {groupEdit ? (
          <DndProvider backend={HTML5Backend}>
            <div className={styles['groupBox-body--dragbox']}>
              {tags.map((item, index) => (
                <DragTag
                  changePosition={changePosition}
                  index={index}
                  {...item}
                  selected={selected}
                  changeGroup={e => setSelected(e)}
                  key={item.id}
                />
              ))}
              <InsertTag handleOpen={setIsModalOpen} />
            </div>
          </DndProvider>
        ) : (
          <div className={styles['groupBox-body--dragbox']}>
            {tags.map((item, index) => (
              <Tag
                key={item.id}
                onClick={() => setSelected(index)}
                className={[
                  styles['groupBox-body--tag-normal'],
                  selected === index ? styles['groupBox-body--tag__cur'] : '',
                ]}
              >
                <span className={styles['groupBox-body--tag__text']}>{item.text}</span>
              </Tag>
            ))}
            <InsertTag handleOpen={setIsModalOpen} />
          </div>
        )}
      </div>
      <GroupInfo isModalOpen={isModalOpen} handleClose={setIsModalOpen} />
    </div>
  );
};

export default GoodsGroup;
