import React from 'react';
import { Modal, Form, Input, TreeSelect, notification } from 'antd';
import { shopAudit } from './services';

const FormItem = Form.Item;
const { TextArea } = Input;
const AuditModal = props => {
  const {
    visible,
    onCancel,
    form: { getFieldDecorator, getFieldValue, validateFields, resetFields },
    formData = {},
  } = props;

  const handleCancel = isSuccess => {
    resetFields();
    onCancel(isSuccess);
  };
  const treeData = [
    {
      title: '同意',
      value: '1',
    },
    {
      title: '不同意',
      value: '2',
      children: [
        {
          title: '商品与出售商品不符',
          value: '2-1',
        },
        {
          title: '影响二次销售',
          value: '2-2',
        },
      ],
    },
  ];
  const handleOk = () => {
    // 掉接口
    // 成功后掉取消接口
    validateFields(async (error, fieldsValue) => {
      if (!error) {
        let { auditResult } = fieldsValue;
        const refuseCode = auditResult.split('-')?.[1] || '';
        auditResult = auditResult.split('-')?.[0];
        const data = await shopAudit({
          ...fieldsValue,
          refuseCode,
          auditResult,
          serviceNo: formData?.serviceNo,
        });
        if (data.code === '0000') {
          notification.success({ message: '审核成功' });
          handleCancel(true);
        }
      }
    });
  };

  const layout = {
    labelCol: { span: 6 },
    wrapperCol: { span: 16 },
  };
  const isAgree = () => getFieldValue('auditResult') === '1';
  const isRefuse = () => getFieldValue('auditResult') && getFieldValue('auditResult') !== '1';

  return (
    <Modal
      title="售后操作确认"
      visible={visible}
      onOk={() => handleOk()}
      onCancel={() => handleCancel()}
    >
      <Form {...layout} name="formData">
        <FormItem label="" style={{ marginLeft: '120px' }}>
          {getFieldDecorator('auditResult')(
            <TreeSelect
              style={{ width: '315px' }}
              dropdownStyle={{ maxHeight: 400, overflow: 'auto' }}
              treeData={treeData}
              placeholder="请选择"
            />,
          )}
        </FormItem>
        {isAgree() && (
          <div>
            <FormItem label="退货地址">
              {getFieldDecorator('receiveAddress', {
                initialValue: formData.address,
                rules: [
                  {
                    required: true,
                    message: '请填写退货地址!',
                  },
                ],
              })(<Input placeholder="请填写退货地址" allowClear />)}
            </FormItem>
            <FormItem label="收件人">
              {getFieldDecorator('receiverName', {
                initialValue: formData.name,
                rules: [
                  {
                    required: true,
                    message: '请填写收件人!',
                  },
                ],
              })(<Input placeholder="请填写收件人" allowClear />)}
            </FormItem>
            <FormItem label="手机号码">
              {getFieldDecorator('receiverPhone', {
                initialValue: formData.phone,
                rules: [
                  {
                    required: true,
                    message: '请填写手机号码!',
                  },
                ],
              })(<Input placeholder="请填写手机号码" allowClear />)}
            </FormItem>
          </div>
        )}
        {isRefuse() && (
          <FormItem label="拒绝原因">
            {getFieldDecorator('refuseDesc', {
              initialValue: formData.refuseDesc,
              rules: [
                {
                  required: true,
                  message: '请填写拒绝原因!',
                },
              ],
            })(<TextArea placeholder="请填写拒绝原因" allowClear />)}
          </FormItem>
        )}
      </Form>
    </Modal>
  );
};

export default Form.create()(AuditModal);
