import React, { useState, useRef } from 'react';
import { Button, notification } from 'antd';
import ProTable from '@ant-design/pro-table';
import { PageHeaderWrapper } from '@ant-design/pro-layout';
import { searchList, auditInfoApi, jdInfo } from './services';
import { appealType } from './data';
import AuditModal from './auditModal';
import DetailTable from './detailTable';
import ProofsModal from './proofsModal';

// 售后状态和售后类型，售后原因枚举，
export default () => {
  const table = useRef();
  const [visible, setVisible] = useState(false);
  const [detailVisible, setDetailVisible] = useState(false);
  const [detailInfo, setDetailInfo] = useState([]);
  const [proofsVisible, setProofsVisible] = useState(false);
  const [proofsData, setProofsData] = useState([]);
  const [auditInfo, setAuditInfo] = useState({});
  const viewDetail = async ({ serviceNo }) => {
    const data = await jdInfo({ serviceNo });
    setDetailInfo(data?.skuQuantity || []);
    setDetailVisible(true);
  };
  const closeModal = isReload => {
    if (isReload) {
      // eslint-disable-next-line no-unused-expressions
      table.current?.reload?.();
    }
    setVisible(false);
    setDetailVisible(false);
    setProofsVisible(false);
  };
  const openAudit = async ({ serviceNo }) => {
    const data = await auditInfoApi({ serviceNo });
    setAuditInfo({ ...data?.data, serviceNo });
    setVisible(true);
  };
  const viewProofs = proofs => {
    if (!proofs) {
      notification.warning({ message: '该订单没有凭证' });
      return;
    }
    setProofsData(proofs.split(','));
    setProofsVisible(true);
  };
  const columns = [
    {
      title: '订单ID',
      dataIndex: 'orderNo',
      hideInSearch: true,
    },
    {
      title: '售后单ID',
      dataIndex: 'serviceNo',
      hideInSearch: true,
    },
    {
      title: '收货人姓名',
      dataIndex: 'receiverName',
    },
    {
      title: '收货人手机号',
      dataIndex: 'receiverPhone',
    },
    {
      title: '收货人地址',
      dataIndex: 'receiveAddress',
      hideInSearch: true,
    },
    {
      title: '售后类型',
      dataIndex: 'serviceType',
      hideInSearch: true,
      valueEnum: {
        1: '退款不退货',
        2: '退货退款',
      },
    },
    {
      title: '售后原因',
      dataIndex: 'serviceReason',
      hideInSearch: true,
    },
    {
      title: '售后凭证',
      dataIndex: 'proofs',
      hideInSearch: true,
      render: proofs => <a onClick={() => viewProofs(proofs)}>查看凭证</a>,
    },
    {
      title: '售后发生时间',
      dataIndex: 'serviceTime',
      hideInSearch: true,
    },
    {
      title: '超时时间',
      dataIndex: 'overTime',
      hideInSearch: true,
    },
    {
      title: '是否催办',
      dataIndex: 'reminderFlag',
      hideInSearch: true,
      valueEnum: {
        1: '是',
        2: '否',
      },
    },
    {
      title: '是否同意售后',
      dataIndex: 'isAgree',
      hideInSearch: true,
    },
    {
      title: '拒绝原因',
      dataIndex: 'refuseReason',
      hideInSearch: true,
    },
    {
      title: '售后申诉',
      dataIndex: 'appealFlag',
      valueEnum: appealType,
      hideInSearch: true,
    },
    {
      title: '操作',
      hideInSearch: true,
      width: 200,
      render: (_, r) => [
        <Button key="link1" onClick={() => openAudit(r)} className="mr10" type="primary">
          审核
        </Button>,
        <Button key="link" onClick={() => viewDetail(r)} type="primary">
          订单详情
        </Button>,
      ],
    },
  ];
  return (
    <PageHeaderWrapper>
      <ProTable
        columns={columns}
        request={searchList}
        rowKey="orderNo"
        pagination={{
          pagesSize: 20,
        }}
        bordered
        actionRef={table}
        scroll={{ x: '100%' }}
        search={{
          collapsed: false,
        }}
      />
      <AuditModal visible={visible} onCancel={closeModal} formData={auditInfo} />
      <DetailTable visible={detailVisible} onCancel={closeModal} dataSource={detailInfo} />
      <ProofsModal visible={proofsVisible} onCancel={closeModal} data={proofsData} />
    </PageHeaderWrapper>
  );
};
