import request from '@/utils/request';
import config from '../../../config/env.config';
import { stringify } from 'qs';
import _ from 'lodash';

const { kdspApi } = config;

// 分页查询所有数据
export async function searchList(params) {
  const param = {
    ...params,
    pageNo: params.current,
    pageSize: params.pageSize || 20,
  };
  const data = await request.post('/api/merchants/shops/list', {
    prefix: kdspApi,
    data: _.omitBy(param, v => !v),
  });
  if (data.data) {
    return {
      total: data.data.total,
      data: data.data.records,
    };
  }
  return {
    total: 0,
    data: [],
  };
}

// 停启用门店
export async function apiEnableStore({ id, state }) {
  const data = await request.get(`/api/merchants/shops/states/edit/${id}/${state}`, {
    prefix: kdspApi,
  });
  return data.businessCode;
}

// 获取地址
export async function apiAddrArea(params) {
  const data = await request.post('/api/merchants/addresses/list', {
    prefix: kdspApi,
    data: stringify(_.omitBy(params, v => !v)),
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
    },
  });
  return data.data || [];
}

// 创建门店
export async function apiCreatStore(params) {
  const data = await request.post('/api/merchants/shops/add', {
    prefix: kdspApi,
    data: params,
  });
  return data.businessCode;
}

// 更新门店
export async function apiEditStore(params) {
  const data = await request.post('/api/merchants/shops/edit', {
    prefix: kdspApi,
    data: params,
  });
  return data.businessCode;
}

// 获取商户业务模式
export async function apiproductBusiness() {
  const data = await request.get('/api/merchants/suppliers/product-business/list', {
    prefix: kdspApi,
  });
  return data.data;
}
