import { Form, Button, Input, Select, notification, Upload, Cascader, InputNumber } from 'antd';
import React, { Component } from 'react';
import { connect } from 'dva';
import styles from '../style.less';
import { stateList } from '../staticdata';

const FormItem = Form.Item;
const { Option } = Select;
@connect(({ goodsManage }) => ({
  goodsManage,
}))
class goodsManage extends Component {
  formRef = React.createRef();

  componentDidMount() {
    this.props.onRef(this);
    this.handleSearch();
  }

  getFieldsValue() {
    const form = this.formRef.current;
    return form.getFieldsValue();
  }

  handleSearch = () => {
    this.props.handleSearch(1);
  };

  valueMin = value => {
    const { getFieldValue, setFieldsValue } = this.formRef.current;
    const minVal = getFieldValue('supplyPriceMin');
    if (minVal && minVal > value) {
      setFieldsValue({ supplyPriceMax: minVal });
    }
  };

  onReset = () => {
    const form = this.formRef.current;
    form.resetFields();
    this.props.onReset();
  };

  addSpu = () => {
    this.props.addSpu();
  };

  setArea = isAll => {
    this.props.setArea(isAll);
  };

  render() {
    const { treeData } = this.props;
    const selectW = { width: 250 };
    const iptNumWidth = { width: 118 };
    const that = this;
    // const uploadProps = {
    //   name: 'file',
    //   async customRequest(info) {
    //     const result = await uploadFile(info.file);
    //     if (result && result.businessCode === '0000') {
    //       that.handleSearch();
    //       notification.success({
    //         message: '操作成功',
    //       });
    //     } else {
    //       notification.warning({
    //         message: result.msg,
    //         description: (
    //           <div>
    //             {result.data?.length &&
    //               result.data.map(item => <p>{item.skuNo + item.errSkuMessage}</p>)}
    //           </div>
    //         ),
    //         duration: 6,
    //       });
    //     }
    //   },
    //   accept: '.xlsx',
    //   showUploadList: false,
    // };

    const filterOption = (input, op) => op.props.children.includes(input);
    return (
      <Form
        ref={this.formRef}
        name="horizontal_login"
        layout="inline"
        className={styles.searchForm}
      >
        <FormItem label="SKU编码" name="skuId">
          <Input placeholder="请输入SKU编码" allowClear style={selectW} />
        </FormItem>
        <FormItem label="商品名称" name="skuName">
          <Input placeholder="请输入商品名称" allowClear style={selectW} />
        </FormItem>
        <FormItem label="类目" name="productCategoryId">
          <Cascader
            placeholder="请选择类目"
            style={selectW}
            showSearch
            changeOnSelect
            fieldNames={{ label: 'name', value: 'id', children: 'children' }}
            options={treeData}
          />
        </FormItem>
        <FormItem label="审核状态" name="state">
          <Select
            style={selectW}
            placeholder="请选择审核状态"
            allowClear
            filterOption={filterOption}
          >
            {stateList?.map(item => (
              <Option key={item.value} value={item.value}>
                {item.label}
              </Option>
            ))}
          </Select>
        </FormItem>
        <FormItem label="供货价区间">
          <FormItem name="supplyPriceMin" className={styles.iptNumRight} noStyle>
            <InputNumber placeholder="请输入" style={iptNumWidth} />
          </FormItem>
          <span>--</span>
          <FormItem name="supplyPriceMax" className={styles.iptNumRight} noStyle>
            <InputNumber style={iptNumWidth} placeholder="请输入" onChange={this.valueMin} />
          </FormItem>
        </FormItem>
        <FormItem name="thirdSkuNo" label="第三方SKU编码">
          <Input placeholder="请输入第三方SKU编码" allowClear style={selectW} />
        </FormItem>
        <FormItem className={styles.queryBtn}>
          <Button onClick={() => this.handleSearch()} type="primary" className={styles.button}>
            查询
          </Button>
          <Button onClick={() => this.onReset()} type="primary" className={styles.button}>
            重置
          </Button>
        </FormItem>
        <FormItem style={{ float: 'right' }}>
          <Button type="primary" className={styles.button} onClick={() => this.setArea(1)}>
            全部配送不支持配置区域
          </Button>
          <Button type="primary" className={styles.button} onClick={() => this.setArea(0)}>
            批量设置不支持配送区域
          </Button>
          <Button type="primary" className={styles.button}>
            批量操作
          </Button>
          <Button type="primary" className={styles.button} onClick={this.addSpu}>
            新增商品
          </Button>
          {/* <Button
            className={styles.button}
            type="primary"
            icon="download"
            ghost
            onClick={() => {
              window.location.href = 'https://kdspstatic.q-gp.com/批量修改库存模板.xlsx';
            }}
          >
            模版
          </Button>
          <Upload {...uploadProps}>
            <Button type="primary" className={styles.button}>
              批量库存修改
            </Button>
          </Upload> */}
        </FormItem>
      </Form>
    );
  }
}

export default goodsManage;
