import React, { useState, useEffect, forwardRef } from 'react';
import { Button, Modal } from 'antd';

const AddMenusModal = props => {
  const [confirmLoading, setConfirmLoading] = useState(false);
  const [modalText, setModalText] = useState('Content of the modal');
  const { open, setOpen } = props;
  const handleOk = () => {
    setModalText('The modal will be closed after two seconds');
    setConfirmLoading(true);
    setTimeout(() => {
      setOpen(false);
      setConfirmLoading(false);
    }, 2000);
  };

  const handleCancel = () => {
    console.log('Clicked cancel button');
    setOpen(false);
  };
  useEffect(() => {
    console.log('open', open);
  }, [open]);
  return (
    <>
      {open && 222}
      {open && (
        <Modal
          title="Title"
          open={open}
          onOk={handleOk}
          confirmLoading={confirmLoading}
          onCancel={handleCancel}
        >
          <p>{modalText}</p>
        </Modal>
      )}
    </>
  );
};

export default forwardRef(AddMenusModal);
