import React from 'react';
import { Button } from 'antd';

export const layout = {
  labelCol: { span: 4 },
  wrapperCol: { span: 18 },
};

// 餐品类型：（1外卖 2 自助餐 4到店）
export const mealType = {
  1: '外卖',
  2: '自助餐',
  4: '到店',
};

export const infoOptions = [
  { label: '商品价格及图片', value: 1 },
  { label: '仅商品价格', value: 2 },
  { label: '仅商品图片', value: 3 },
  { label: '均不展示', value: 4 },
];

export const boolOptions = [{ label: '是', value: 1 }, { label: '否', value: 0 }];
export const hideOptions = [
  { label: '隐藏商品价格', value: 'hidePrice' },
  { label: '隐藏商品图片', value: 'hideImage' },
];

// export const mealSections = [
//   {
//     label: '早餐',
//     value: '1',
//     key: 'time1',
//   },
//   {
//     label: '中餐',
//     value: '2',
//     key: 'time2',
//   },
//   {
//     label: '晚餐',
//     value: '4',
//     key: 'time4',
//   },
// ];
export const mealSections = {
  1: '早餐',
  2: '中餐',
  4: '晚餐',
};

// 企业列表字段
export const customerColumn = options => {
  const { onEdit } = options;
  return [
    {
      title: 'ID',
      dataIndex: 'enterpriseId',
      hideInTable: true,
    },
    {
      title: 'ID',
      dataIndex: 'id',
      width: 120,
      align: 'center',
      hideInSearch: true,
    },
    {
      title: '公司名称',
      dataIndex: 'name',
      width: 120,
      align: 'center',
    },
    {
      title: '截单时间(分钟)',
      dataIndex: 'endOrderTime',
      width: 120,
      align: 'center',
      hideInSearch: true,
    },
    {
      title: '餐品类型',
      dataIndex: 'mealType',
      width: 120,
      align: 'center',
      hideInSearch: true,
      render(types) {
        const arr = types.map(meal => mealType[meal]);
        return arr.join('/');
      },
    },
    {
      title: '创建人',
      dataIndex: 'createdBy',
      width: 120,
      align: 'center',
      hideInSearch: true,
    },
    {
      title: '创建时间',
      dataIndex: 'createdAt',
      width: 120,
      align: 'center',
      hideInSearch: true,
    },
    {
      title: '操作',
      hideInSearch: true,
      dataIndex: 'action',
      width: 200,
      align: 'center',
      fixed: 'right',
      render: (val, r) => (
        <Button key="edit" onClick={() => onEdit(r, 'edit')}>
          编辑
        </Button>
      ),
    },
  ];
};
