import request from '@/utils/request';
import config from '../../../config/env.config';
import { stringify } from 'qs';
import _ from 'lodash';

const { goodsApi, apiPrefix, roleApi } = config;

//  [企业员工]-列表查询
//  http://yapi.quantgroups.com/project/389/interface/api/65359
export const apiStaffList = async params => {
  const data = await request.post(`${apiPrefix}/enterprise/staff/pageList`, {
    prefix: roleApi,
    data: params,
  });
  return data;
};

// [企业客户]-列表查询
// http://yapi.quantgroups.com/project/389/interface/api/65324
export const apiEnterpriseList = async () => {
  const data = await request.post(`${apiPrefix}/enterprise/pageList`, {
    prefix: roleApi,
    data: {
      page: 1,
      size: 10000,
    },
  });
  return data;
};

// [企业部门]-列表查询
// http://yapi.quantgroups.com/project/389/interface/api/65344
export const apiDepartmentList = async params => {
  const data = await request.post(`${apiPrefix}/enterprise/department/pageList`, {
    prefix: roleApi,
    data: params,
  });
  return data;
};

// [企业员工]-添加员工
// http://yapi.quantgroups.com/project/389/interface/api/65364
export const apiStaffSave = async params => {
  const data = await request.post(`${apiPrefix}/enterprise/staff/save`, {
    prefix: roleApi,
    data: params,
  });
  return data;
};

// [企业员工]-导入员工
// http://yapi.quantgroups.com/project/389/interface/api/65384
export const apiStaffExcel = async file => {
  console.log(file);
  const params = new FormData();
  params.append('file', file.file.file);
  params.append('enterpriseId', file.enterpriseId);
  const data = await request.post(`${apiPrefix}/enterprise/staff/excel`, {
    prefix: roleApi,
    data: params,
  });
  return data;
};

// [企业部门]-新增企业部门
// http://yapi.quantgroups.com/project/389/interface/api/65349
export const apiDepartmentSave = async params => {
  const data = await request.post(`${apiPrefix}/enterprise/department/save`, {
    prefix: roleApi,
    data: params,
  });
  return data;
};

// [企业部门]-导入企业部门
// http://yapi.quantgroups.com/project/389/interface/api/65354
export const apiDepartmentExcel = async file => {
  const params = new FormData();
  params.append('file', file.file.file);
  params.append('enterpriseId', file.enterpriseId);
  const data = await request.post(`${apiPrefix}/enterprise/department/excel`, {
    prefix: roleApi,
    data: params,
  });
  return data;
};

// [企业员工]-删除员工
// http://yapi.quantgroups.com/project/389/interface/api/65374
export const apiStaffDelete = async params => {
  const data = await request.post(`${apiPrefix}/enterprise/staff/delete`, {
    prefix: roleApi,
    data: params,
  });
  return data;
};

// [企业部门]-更新部门
// http://yapi.quantgroups.com/project/389/interface/api/65474
export const apiDepartmentUpdate = async params => {
  const data = await request.post(`${apiPrefix}/enterprise/department/update`, {
    prefix: roleApi,
    data: params,
  });
  return data;
};

// [企业员工]-充值明细查询
// http://yapi.quantgroups.com/project/389/interface/api/65489
export const apiGenerateLogList = async params => {
  const data = await request.get(`${apiPrefix}/enterprise/staff/generateLog/list`, {
    prefix: roleApi,
    params,
  });
  return data;
};

// [企业员工]-员工限额
// http://yapi.quantgroups.com/project/389/interface/api/65379
export const apiStaffLimit = async params => {
  const data = await request.post(`${apiPrefix}/enterprise/staff/limit`, {
    prefix: roleApi,
    data: params,
  });
  return data;
};

// [企业员工]-拉黑员工
// http://yapi.quantgroups.com/project/389/interface/api/65369
export const apiStaffBlack = async params => {
  const data = await request.post(`${apiPrefix}/enterprise/staff/black`, {
    prefix: roleApi,
    data: params,
  });
  return data;
};
