import { Input, Modal, Button, Form, Table, InputNumber } from 'antd';
import React, {
  useContext,
  createContext,
  useEffect,
  useState,
  forwardRef,
  useImperativeHandle,
} from 'react';
import { ServiceContext } from '../context';
import { CreateFormInput } from './CommonTemplate';
import UUID from '../../../utils/uuid';

const UpdateSkuName = ({ skuVisble, value, confirmEvent, cancelEvent }) => {
  const [skuForm] = Form.useForm();

  const handleCancel = () => {
    skuForm.resetFields();
    cancelEvent();
  };
  const handleSaveEvent = async () => {
    try {
      const result = await skuForm.validateFields();
      confirmEvent({ skuName: result.skuName, rowIndex: value.rowIndex });
      handleCancel();
    } catch (error) {
      console.log(error);
    }
  };
  return (
    <Modal title="修改SKU名称" visible={skuVisble} onOk={handleSaveEvent} onCancel={handleCancel}>
      <Form form={skuForm} name="skuRegister">
        <Form.Item
          label="sku名称"
          key="skuName"
          name="skuName"
          initialValue={value.skuName}
          rules={[{ required: true, message: '请输入sku名称！' }]}
        >
          <Input.TextArea autoSize={{ minRows: 2, maxRows: 6 }} allowClear />
        </Form.Item>
      </Form>
    </Modal>
  );
};

const EditableContext = createContext(null);
const EditFormTable = forwardRef((props, ref) => {
  const { initData, defaultColumns, setTableData, mergeTable } = props;
  const customer = useContext(ServiceContext);
  const [dataSource, setDataSource] = useState([]);
  const [skuVisble, setSkuVisble] = useState(false);
  const [skuNameItem, setSkuNameItem] = useState({
    skuName: '',
    rowIndex: null,
  });
  const [form] = Form.useForm();
  useEffect(() => {
    form.setFieldsValue({
      tableList: initData,
    });
    console.log('==============>生成的表格数据', initData);
    setDataSource([...initData]);
  }, [initData]);

  // const handleSave = row => {
  //   form.setFieldsValue({
  //     tableList: [...row],
  //   });
  //   const dataList = [...dataSource];
  //   dataList[rowIndex][dataIndex] = value;
  //   setDataSource([...dataList]);
  // };

  const handleSave = (value, dataIndex, rowIndex) => {
    // form.setFieldsValue({
    //   [`tableList[${rowIndex}][${dataIndex}]`]: value,
    // });
    const dataList = [...dataSource];
    dataList[rowIndex][dataIndex] = value;
    setDataSource([...dataList]);
  };

  const onCheck = async () => {
    try {
      const { tableList } = await form.validateFields();
      console.log('===============>编辑表格', tableList);
      const newTableList = customer.isEdit
        ? [...dataSource]
        : [...tableList].map(item => {
            const { rowSpanCount, option, ...childItem } = item;
            return childItem;
          });
      console.log('===============>newTableList', newTableList);
      return newTableList;
    } catch (errorInfo) {
      console.log(errorInfo);
      return null;
    }
  };

  const rowOnClickEvent = row => {
    setSkuVisble(true);
    setSkuNameItem({
      skuName: row.name,
      rowIndex: row.rowIndex,
    });
  };

  const cancelEvent = () => {
    setSkuVisble(false);
  };

  const confirmEvent = skuItem => {
    const newDataSource = [...dataSource];
    newDataSource[skuItem.rowIndex].name = skuItem.skuName;
    setDataSource(newDataSource);
    form.setFieldsValue({
      tableList: newDataSource,
    });
  };
  const onClickEvent = () => {};

  useImperativeHandle(ref, () => ({
    onCheck,
    form,
  }));
  const save = async () => {
    try {
      const tableList = form.getFieldValue('tableList');
      handleSave(tableList);
    } catch (errInfo) {
      console.log('Save failed:', errInfo);
    }
  };
  // 根据这里做判断渲染表格
  const columns = defaultColumns
    .filter(item => !item.role || item.role.includes(customer.productType))
    .map((col, colIndex) => ({
      ...col,
      align: 'center',
      render(text, record, rowIndex) {
        const {
          dataIndex,
          title,
          editable,
          roleRules = {},
          roleProps = {},
          inputType,
          ...otherParams
        } = col;
        const disabled = Boolean(col.disabeldRender ? col.disabeldRender(record) : false);
        const childrenElement = (
          <Form.Item
            style={{ margin: 0 }}
            key={`${dataIndex}_${rowIndex}`}
            name={['tableList', rowIndex, dataIndex]}
            initialValue={record[dataIndex] || null}
            rules={[{ required: roleRules.required, message: `请输入${title}.` }]}
          >
            <CreateFormInput
              {...otherParams}
              title={title}
              type={inputType}
              record={record}
              rowIndex={rowIndex}
              roleProps={roleProps}
              dataIndex={dataIndex}
              disabled={disabled}
              onBlurEvent={handleSave}
              onClickEvent={onClickEvent}
            />
          </Form.Item>
        );
        const rowProps = { children: childrenElement, props: {} };
        if (dataIndex === 'firstSpecValue' && mergeTable) {
          const rowSpan = record.rowSpanCount;
          rowProps.props.rowSpan = rowSpan || 0;
        }
        return rowProps;
      },
    }));

  return (
    <>
      <Form form={form} scrollToFirstError component={false}>
        <Button onClick={onCheck}>测试</Button>
        <EditableContext.Provider value={form}>
          <Table
            height={300}
            pagination={false}
            size="small"
            bordered
            dataSource={dataSource}
            columns={columns}
          />
        </EditableContext.Provider>
      </Form>
      <Button onClick={() => {}}></Button>
      <UpdateSkuName
        skuVisble={skuVisble}
        form={form}
        value={skuNameItem}
        confirmEvent={confirmEvent}
        cancelEvent={cancelEvent}
      />
    </>
  );
});

export default EditFormTable;
