import React from 'react';
import { Divider } from 'antd';

export const getColumns = props => {
  const {
    toUserInfo,
    openRolePermissionsModal,
    openUpdateStatusModal,
    openResetPasswordModal,
    canEditable,
  } = props;
  return [
    {
      title: $t('username'),
      dataIndex: 'account',
    },
    {
      title: $t('name'),
      dataIndex: 'name',
    },
    {
      title: $t('creation.time'),
      dataIndex: 'createTime',
      hideInSearch: true,
    },
    {
      title: $t('last.login.time'),
      dataIndex: 'lastLogin',
      hideInSearch: true,
    },
    {
      title: $t('role'),
      dataIndex: 'creator',
      render: (value, record) => {
        const { roles } = record;
        const roleElement = roles.map((role, index) => (
          <>
            <a onClick={() => openRolePermissionsModal(role)}>{role.name}</a>
            {roles.length - 1 !== index ? '，' : ''}
          </>
        ));
        return roleElement;
      },
    },
    {
      title: $t('status'),
      dataIndex: 'status',
      width: 150,
      initialValue: '3',
      hideInFilter: true,
      valueEnum: {
        all: { text: $t('all'), status: '' },
        close: { text: $t('in.use'), status: 2 },
        running: { text: $t('disabled'), status: 3 },
      },
      render: value => {
        const textMapping = {
          2: $t('used'),
          3: $t('disabled'),
        };
        return textMapping[value.value] || '-';
      },
    },
    {
      title: $t('actions'),
      key: 'action',
      width: 220,
      hideInSearch: true,
      render: (value, record) => {
        if (!canEditable) {
          return <>-</>;
        }
        return (
          <>
            <a
              onClick={() => {
                toUserInfo(record);
              }}
            >{$t('edit')}</a>
            <Divider type="vertical" />
            <a
              onClick={() => {
                openUpdateStatusModal(record);
              }}
            >{$t('edit.status')}</a>
            <Divider type="vertical" />
            <a
              onClick={() => {
                openResetPasswordModal(record);
              }}
            >{$t('reset.password')}</a>
          </>
        );
      },
    },
  ];
};
