import { Button } from 'antd';
import React, { useRef, useState } from 'react';
import { PageHeaderWrapper } from '@ant-design/pro-layout';
import ProTable from '@ant-design/pro-table';
import styles from '../index.less';
import ActionModal from './modal';
import { detailQuery } from '../services';

const TableList = props => {
  const [visibleModal, setVisibleModal] = useState(false);
  const [modalValue, setModalValue] = useState({});

  const { batchNo } = props.location.query;

  const actionRef = useRef();

  const reload = () => {
    actionRef.current.reload();
  };
  const onClose = type => {
    if (type) {
      reload();
    }
    setVisibleModal(false);
  };
  const openAction = row => {
    setModalValue(() => row);
    setVisibleModal(true);
  };

  const columns = [
    {
      title: $t('order.no'),
      dataIndex: 'orderNo',
      key: 'orderNo',
      hideInSearch: true,
    },
    {
      title: $t('jd.order.id'),
      dataIndex: 'jdOrderId',
      key: 'jdOrderId',
      hideInSearch: true,
    },
    {
      title: $t('aftersales.order.id'),
      dataIndex: 'afterServiceNo',
      key: 'afterServiceNo',
      hideInSearch: true,
    },
    {
      title: $t('our.transaction.amount'),
      dataIndex: 'ownTradeAmount',
      key: 'ownTradeAmount',
      hideInSearch: true,
    },
    {
      title: $t('thirdparty.transaction.amount'),
      dataIndex: 'thirdTradeAmount',
      key: 'thirdTradeAmount',
      hideInSearch: true,
    },
    {
      title: $t('transaction.type'),
      dataIndex: 'tradeType',
      key: 'tradeType',
      hideInSearch: true,
      valueEnum: {
        1: $t('order.payment'),
        2: $t('order.cancellation.refund'),
        3: $t('aftersales.refund'),
      },
    },
    {
      title: $t('transaction.date'),
      dataIndex: 'tradeDate',
      key: 'tradeDate',
      hideInSearch: true,
    },
    {
      title: $t('status'),
      dataIndex: 'status',
      key: 'status',
      valueEnum: {
        1: $t('average'),
        2: $t('mismatched'),
      },
    },
    {
      title: $t('remark.info'),
      dataIndex: 'remarks',
      key: 'remarks',
      hideInSearch: true,
    },
    {
      title: $t('actions'),
      dataIndex: 'townName',
      key: 'townName',
      hideInSearch: true,
      render: (_, row) => [
        <Button
          key="edit"
          type="primary"
          onClick={() => {
            openAction(row);
          }}
        >{$t('complete')}</Button>,
      ],
    },
  ];
  return (
    <PageHeaderWrapper>
      <ProTable
        className={styles.protable}
        actionRef={actionRef}
        columns={columns}
        params={{ batchNo }}
        request={res => detailQuery(res)}
        rowKey="id"
        bordered
        scroll={{ x: 1500 }}
        search={{
          collapsed: false,
        }}
      />
      <ActionModal visible={visibleModal} formData={modalValue} onClose={onClose}></ActionModal>
    </PageHeaderWrapper>
  );
};

export default TableList;
