/*  验证必填项 */
export const validateRequired = (rule, value, callback) => {
  const reg = /^\s*$/;
  if (!value || reg.test(value)) {
    callback(new Error($t('required')));
  } else {
    callback();
  }
};

/* 是否合法IP地址 */
export function validateIP(rule, value, callback) {
  if (!value || value === 'undefined') {
    callback();
  } else {
    const reg = /^(\d{1,2}|1\d\d|2[0-4]\d|25[0-5])\.(\d{1,2}|1\d\d|2[0-4]\d|25[0-5])\.(\d{1,2}|1\d\d|2[0-4]\d|25[0-5])\.(\d{1,2}|1\d\d|2[0-4]\d|25[0-5])$/;
    if (!reg.test(value) && value !== '') {
      callback(new Error($t('enter.valid.ip')));
    } else {
      callback();
    }
  }
}

/*  是否手机号码或者固话 */
export function validatePhoneTwo(rule, value, callback) {
  const reg = /^((0\d{2,3}-\d{7,8})|(1[34578]\d{9}))$/;
  if (!value || value === 'undefined') {
    callback();
  } else if (!reg.test(value) && value !== '') {
    callback(new Error($t('phone.or.landline.required')));
  } else {
    callback();
  }
}
/*  是否固话 */
export function validateTelphone(rule, value, callback) {
  const reg = /0\d{2}-\d{7,8}/;
  if (!value || value === 'undefined') {
    callback();
  } else if (!reg.test(value) && value !== '') {
    callback(new Error($t('enter.landline.eg.0101234567')));
  } else {
    callback();
  }
}
/*  是否手机号码 */
export function validatePhone(rule, value, callback) {
  const reg = /^[1][3,4,5,6,7,8,9][0-9]{9}$/;
  if (!value || value === 'undefined') {
    return Promise.resolve();
  }
  if (!reg.test(value) && value !== '') {
    return Promise.reject(new Error($t('enter.valid.phone')));
  }
  return Promise.resolve();
}
/*  是否身份证号码 */
export function validateIdNo(rule, value, callback) {
  const reg = /(^\d{15}$)|(^\d{18}$)|(^\d{17}(\d|X|x)$)/;
  if (!value || value === 'undefined') {
    callback();
  } else if (!reg.test(value) && value !== '') {
    callback(new Error($t('enter.valid.id.number')));
  } else {
    callback();
  }
}
/*  是否邮箱 */
export function validateEMail(rule, value, callback) {
  const reg = /^([a-zA-Z0-9]+[-_.]?)+@[a-zA-Z0-9]+.[a-z]+$/;
  if (!value || value === 'undefined') {
    callback();
  } else if (!reg.test(value)) {
    callback(new Error($t('enter.valid.email')));
  } else {
    callback();
  }
}
/* 验证内容是否英文数字以及下划线 */
export function isPassword(rule, value, callback) {
  const reg = /^[_a-zA-Z0-9]+$/;
  if (!value || value === 'undefined') {
    callback();
  } else if (!reg.test(value)) {
    callback(new Error($t('password.letters.numbers.underscores.only')));
  } else {
    callback();
  }
}

/* 自动检验数值的范围 */
export function checkMaxNumber(rule, value, callback) {
  const re = /^[1-9][0-9]{0,1}$/;
  const rsCheck = re.test(value);
  if (!value || value === 'undefined') {
    callback();
  } else if (rule.isInteger && !rsCheck) {
    callback(new Error(`请输入[${rule.min}, ${rule.max}]之间的正整数`));
  } else if (!Number(value)) {
    callback(new Error(`请输入[${rule.min}, ${rule.max}]之间的数字`));
  } else if (value < rule.min || value > rule.max) {
    callback(new Error(`请输入[${rule.min}, ${rule.max}]之间的数字`));
  } else {
    callback();
  }
}

// 验证数字输入框最大数值,32767
export function checkMaxVal(rule, value, callback) {
  if (value < 0 || value > 32767) {
    callback(new Error($t('enter.number.032767')));
  } else {
    callback();
  }
}
// 验证是否1-99之间
export function isOneToNinetyNine(rule, value, callback) {
  if (!value) {
    callback(new Error($t('input.required')));
  }
  setTimeout(() => {
    if (!Number(value)) {
      callback(new Error($t('positive.integer.required')));
    } else {
      const re = /^[1-9][0-9]{0,1}$/;
      const rsCheck = re.test(value);
      if (!rsCheck) {
        callback(new Error($t('enter.integer.199')));
      } else {
        callback();
      }
    }
  }, 0);
}

//  验证是否整数
export function isInteger(rule, value, callback) {
  if (!value) {
    callback(new Error($t('input.required')));
  }
  setTimeout(() => {
    if (!Number(value)) {
      callback(new Error($t('positive.integer.required')));
    } else {
      const re = /^[0-9]*[1-9][0-9]*$/;
      const rsCheck = re.test(value);
      if (!rsCheck) {
        callback(new Error($t('positive.integer.required')));
      } else {
        callback();
      }
    }
  }, 0);
}

// 验证是否大于0的整数
export const isIntegerNotZero = (rule, value, callback) => {
  if (!value) {
    callback();
  }
  if (!Number(value)) {
    callback(new Error($t('enter.positive.integer.0')));
  } else {
    const re = /^[1-9][0-9]{0,}$/;
    const rsCheck = re.test(value);
    if (!rsCheck) {
      callback(new Error($t('enter.positive.integer.0')));
    } else {
      callback();
    }
  }
};

/**
 * 验证 数字区间
 * rule.min: 0
 * rule.max: 100
 */
export const isNumberSection = (rule, value, callback) => {
  if (['', undefined, null].includes(value)) {
    callback();
  }
  if (!Number(value)) {
    callback(new Error($t('numbers.required')));
  } else if (rule.min > +value || rule.max < +value) {
    callback(new Error(rule.message || `请输入${rule.min}-${rule.max}区间的数字`));
  } else {
    callback();
  }
};

//  验证是否整数,非必填
export function isIntegerNotMust(rule, value, callback) {
  if (!value) {
    return Promise.resolve();
  }
  if (!Number(value)) {
    return Promise.reject(new Error($t('positive.integer.required')));
  }
  const re = /^[0-9]*[1-9][0-9]*$/;
  const rsCheck = re.test(value);
  if (!rsCheck) {
    return Promise.reject(new Error($t('positive.integer.required')));
  }
  return Promise.resolve();
}

//  验证是否是[0-1]的小数
export function isDecimal(rule, value, callback) {
  if (!value) {
    callback(new Error($t('input.required')));
  }
  setTimeout(() => {
    if (!Number(value)) {
      callback(new Error($t('enter.number.01')));
    } else if (value < 0 || value > 1) {
      callback(new Error($t('enter.number.01')));
    } else {
      callback();
    }
  }, 100);
}

//  验证是否是[1-10]的小数,即不可以等于0
export function isBtnOneToTen(rule, value, callback) {
  if (typeof value === 'undefined') {
    callback(new Error($t('input.required')));
  }
  setTimeout(() => {
    if (!Number(value)) {
      callback(new Error($t('enter.integer.110')));
    } else if (
      !(
        value === '1' ||
        value === '2' ||
        value === '3' ||
        value === '4' ||
        value === '5' ||
        value === '6' ||
        value === '7' ||
        value === '8' ||
        value === '9' ||
        value === '10'
      )
    ) {
      callback(new Error($t('enter.integer.110')));
    } else {
      callback();
    }
  }, 100);
}
//  验证是否是[1-100]的小数,即不可以等于0
export function isBtnOneToHundred(rule, value, callback) {
  if (!value) {
    callback(new Error($t('input.required')));
  }
  setTimeout(() => {
    if (!Number(value)) {
      callback(new Error($t('integer.1100.required')));
    } else if (value < 1 || value > 100) {
      callback(new Error($t('integer.1100.required')));
    } else {
      callback();
    }
  }, 100);
}
//  验证是否是[0-100]的小数
export function isBtnZeroToHundred(rule, value, callback) {
  if (!value) {
    callback(new Error($t('input.required')));
  }
  setTimeout(() => {
    if (!Number(value)) {
      callback(new Error($t('enter.number.1100')));
    } else if (value < 0 || value > 100) {
      callback(new Error($t('enter.number.1100')));
    } else {
      callback();
    }
  }, 100);
}

//  验证端口是否在[0,65535]之间
export function isPort(rule, value, callback) {
  if (!value) {
    callback(new Error($t('input.required')));
  }
  setTimeout(() => {
    if (value === '' || typeof value === 'undefined') {
      callback(new Error($t('enter.port.value')));
    } else {
      const re = /^([0-9]|[1-9]\d|[1-9]\d{2}|[1-9]\d{3}|[1-5]\d{4}|6[0-4]\d{3}|65[0-4]\d{2}|655[0-2]\d|6553[0-5])$/;
      const rsCheck = re.test(value);
      if (!rsCheck) {
        callback(new Error($t('enter.port.number.065535')));
      } else {
        callback();
      }
    }
  }, 100);
}
//  验证端口是否在[0,65535]之间，非必填,isMust表示是否必填
export function isCheckPort(rule, value, callback) {
  if (!value) {
    callback();
  }
  setTimeout(() => {
    if (value === '' || typeof value === 'undefined') {
      //  callback(new Error('请输入端口值'));
    } else {
      const re = /^([0-9]|[1-9]\d|[1-9]\d{2}|[1-9]\d{3}|[1-5]\d{4}|6[0-4]\d{3}|65[0-4]\d{2}|655[0-2]\d|6553[0-5])$/;
      const rsCheck = re.test(value);
      if (!rsCheck) {
        callback(new Error($t('enter.port.number.065535')));
      } else {
        callback();
      }
    }
  }, 100);
}

/*  小写字母 */
export function validateLowerCase(str) {
  const reg = /^[a-z]+$/;
  return reg.test(str);
}
/* 保留2为小数 */
export function validatetoFixedNew(str) {
  return str;
}
/*  验证key */
//  export function validateKey (str) {
//      var reg = /^[a-z_\-:]+$/;
//      return reg.test(str);
//  }

/*  大写字母 */
export function validateUpperCase(str) {
  const reg = /^[A-Z]+$/;
  return reg.test(str);
}

/*  大小写字母 */
export function validatAlphabets(str) {
  const reg = /^[A-Za-z]+$/;
  return reg.test(str);
}

/*  大小写字母数字 */
export function validatAlphabetsNumber(rule, value, callback) {
  const reg = /^[A-Za-z0-9]+$/;
  if (value && !reg.test(value)) {
    callback(new Error($t('letters.or.numbers.only')));
  } else {
    callback();
  }
}

//  验证数字和英文逗号
export function isCheckNumberComma(rule, value, callback) {
  if (!value) {
    callback();
  } else {
    const re = /^\d+(,+\d+)*$/;
    const rsCheck = re.test(value);
    if (!rsCheck) {
      callback(new Error($t('numbers.or.commaseparated')));
    } else {
      callback();
    }
  }
}
//  验证数字和-
export function isCheckNumberLine(rule, value, callback) {
  if (!value) {
    callback();
  } else {
    const re = /^\d+(-+\d+)*$/;
    const rsCheck = re.test(value);
    if (!rsCheck) {
      callback(new Error($t('numbers.or.hyphens')));
    } else {
      callback();
    }
  }
}

// 验证数字价格
export function isCheckNumberPrice(rule, value, callback) {
  if (!value) {
    callback();
  } else if (Number.isNaN(+value)) {
    callback(new Error($t('numbers.required')));
  } else if (+value < 0) {
    callback(new Error($t('enter.number.0')));
  } else {
    callback();
  }
}

// 验证价格保留小数点1位
export function isCheckPriceOneDecimal(rule, value, callback) {
  const num = +value;
  const arr = `${value}`.split('.');
  if (!value) {
    callback();
  } else if (Number.isNaN(num)) {
    callback(new Error($t('numbers.required')));
  } else if (num < 0) {
    callback(new Error($t('enter.number.0')));
  } else if (arr.length === 2 && arr[1].length > 1) {
    callback(new Error($t('1.decimal.place')));
  } else {
    callback();
  }
}
// 验证价格保留小数点2位
export function isCheckPriceTwoDecimal(rule, value, callback) {
  const num = +value;
  const arr = `${value}`.split('.');
  if (!value) {
    callback();
  } else if (Number.isNaN(num)) {
    callback(new Error($t('numbers.required')));
  } else if (num < 0) {
    callback(new Error($t('enter.number.0')));
  } else if (arr.length === 2 && arr[1].length > 2) {
    callback(new Error($t('2.decimal.places')));
  } else {
    callback();
  }
}

// 获取默认校验规则
export const getDefaultRule = data => {
  const isString = typeof data === 'string';
  if (isString) {
    return {
      required: true,
      message: data,
    };
  }
  return Object.assign(
    {
      required: true,
    },
    data,
  );
};

// 输入空格校验
export const validateSpaces = (rule, value, callback) => {
  // 输入不能包括空格
  if (value?.includes(' ')) {
    // eslint-disable-next-line prefer-promise-reject-errors
    return Promise.reject($t('no.spaces.allowed'));
  }
  // 去掉空格后进行进一步校验
  // ...
  return Promise.resolve();
};
