import React, { useState, useRef } from 'react';
import ProTable from '@ant-design/pro-table';
import { Button, Popconfirm, notification } from 'antd';
import { PageHeaderWrapper } from '@ant-design/pro-layout';
import { actionStatus, settleStatus } from './data';
import style from './style.less';
import { query, updateStatus, download, docQuery } from './service';
import FileModal from './fileModal';
import UploadModal from './uploadModal';
import RemarkModal from './remarkModal';

export default () => {
  const protable = useRef();
  const remarkRef = useRef();
  const [showViewFile, setShowViewFile] = useState(false);
  const [viewFileData, setViewFileData] = useState([]);
  const [showViewUpload, setShowViewUpload] = useState(false);
  const [settlementNoV, setSettlementNo] = useState('');
  const [remarkShow, setRemarkShow] = useState(false);
  const [rowInfo, setRowInfo] = useState({});
  const reload = () => {
    if (protable?.current?.reload) {
      protable.current.reload();
    }
  };
  const confirmText = $t('confirm.settlement.amount.action.irreversible');
  const confirmAction = async (r, isRefuse, refuse) => {
    if (isRefuse && !refuse) {
      notification.error({ message: $t('enter.rejection.reason') });
      return;
    }
    const data = await updateStatus({
      id: r.id,
      status: isRefuse ? 4 : 3,
      remarks: isRefuse && refuse,
    });
    if (data.businessCode === '0000') {
      notification.success({ message: $t('operation.success') });
      reload();
    }
  };
  const uploadInvoice = ({ settlementNo }) => {
    setSettlementNo(settlementNo);
    setShowViewUpload(true);
  };
  const downDetail = ({ settlementNo }) => {
    // type 1非财务 2财务
    download({ settlementNo, type: 1 });
  };
  const clearRefuseContent = r => {
    setRowInfo(r);
    if (remarkRef.current.init) {
      remarkRef.current.reset();
    }
    setRemarkShow(true);
  };
  const viewAccessory = async ({ settlementNo }) => {
    const data = await docQuery(settlementNo);
    setViewFileData(data);
    setShowViewFile(true);
  };

  const tableRenderBtn = r => (
    <div>
      <p>
        <Popconfirm
          placement="topLeft"
          title={confirmText}
          onConfirm={() => confirmAction(r)}
          okText={$t('confirm')}
          cancelText={$t('cancel')}
          disabled={r.settlementStatus !== 2}
        >
          <Button type="primary" className="mr10" disabled={r.settlementStatus !== 2}>{$t('confirm')}</Button>
        </Popconfirm>
        <Button
          type="primary"
          onClick={() => clearRefuseContent(r)}
          className="mr10"
          disabled={r.settlementStatus !== 2}
        >{$t('reject')}</Button>
        <Button type="primary" onClick={() => uploadInvoice(r)} disabled={r.settlementStatus !== 6}>{$t('upload.invoice')}</Button>
      </p>
      <Button type="primary" onClick={() => downDetail(r)} className="mr20">{$t('download.details')}</Button>
      <Button
        type="primary"
        onClick={() => viewAccessory(r)}
        disabled={!(r.settlementStatus === 6 && r.isUploadDoc)}
      >{$t('view.attachments')}</Button>
    </div>
  );
  const columns = [
    {
      title: $t('sort'),
      dataIndex: 'index',
      valueType: 'index',
      width: 100,
    },
    {
      title: $t('settlement.order.no'),
      dataIndex: 'settlementNo',
      width: 200,
    },
    {
      title: $t('settlement.cycle'),
      dataIndex: 'settlementTime',
      valueType: 'dateRange',
      hideInTable: true,
      width: 200,
    },
    {
      title: $t('settlement.cycle'),
      dataIndex: 'settlementDate',
      hideInSearch: true,
      width: 200,
    },
    {
      title: $t('pending.settlement.amount'),
      dataIndex: 'settlementAmount',
      hideInSearch: true,
      width: 200,
    },
    {
      title: $t('payment.status'),
      dataIndex: 'settlementStatus',
      valueEnum: settleStatus,
      width: 200,
    },
    {
      title: $t('operation.status'),
      dataIndex: 'supplierOperateStatus',
      valueEnum: actionStatus,
      width: 200,
    },
    {
      title: $t('reason'),
      dataIndex: 'remarktrgyurew',
      hideInSearch: true,
      width: 200,
    },
    {
      title: $t('actions'),
      dataIndex: 'action',
      hideInSearch: true,
      width: 200,
      fixed: 'right',
      render: (_, r) => tableRenderBtn(r),
    },
  ];

  return (
    <PageHeaderWrapper>
      <ProTable
        size="small"
        columns={columns}
        className={style.table}
        request={query}
        search={{ collapsed: false }}
        rowKey={r => r.settlementNo}
        pagination={{
          defaultCurrent: 1,
        }}
        actionRef={protable}
        scroll={{ x: '100%' }}
      />
      <FileModal
        visible={showViewFile}
        fileData={viewFileData}
        onCancel={() => {
          setShowViewFile(false);
        }}
      />
      <UploadModal
        visible={showViewUpload}
        settlementNo={settlementNoV}
        onCancel={() => {
          setShowViewUpload(false);
          reload();
        }}
      />
      <RemarkModal
        visible={remarkShow}
        submit={remark => {
          confirmAction(rowInfo, true, remark);
        }}
        onCancel={() => setRemarkShow(false)}
        ref={remarkRef}
      />
    </PageHeaderWrapper>
  );
};
