import React from 'react';

export const infoColumn = [
  {
    title: $t('order.no'),
    dataIndex: 'orderNo',
    maxLength: 50,
    fieldProps: {
      disabled: true,
    },
  },
  {
    title: $t('receiver.tel'),
    dataIndex: 'receiverMobile',
    fieldProps: {
      maxLength: 11,
    },
    formItemProps: {
      rules: [
        { required: true, message: $t('enter.recipient.phone') },
        {
          pattern: /^1[3456789]\d{9}$/,
          message: $t('enter.valid.phone'),
        },
      ],
      extra: (
        <div style={{ color: '#1890FF' }}>
          <div>{$t('note')}</div>
          <div>{$t('1.modify.with.caution.this.function.is.used.to.update.recipient.info.postshipment.via.offline.logistics')}</div>
          <div>{$t('2.numeric.11digit.phone.only')}</div>
        </div>
      ),
    },
  },
  {
    title: $t('receiver.name'),
    dataIndex: 'receiverName',
    maxLength: 100,
    fieldProps: {
      disabled: true,
    },
  },
  {
    title: $t('delivery.address'),
    dataIndex: 'fullAddress',
    maxLength: 50,
    fieldProps: {
      disabled: true,
    },
  },
];

export const logColumn = [
  {
    title: $t('serial.no'),
    dataIndex: 'orderNo',
    key: 'orderNo',
    width: 80,
    render: (text, record, index) => <div>{index + 1}</div>,
  },
  {
    title: $t('change.time'),
    dataIndex: 'createdAt',
    key: 'createdAt',
    width: 200,
  },
  {
    title: $t('before.change'),
    dataIndex: 'oldVal',
    key: 'oldVal',
    width: 150,
  },
  {
    title: $t('after.change'),
    dataIndex: 'newVal',
    key: 'newVal',
    width: 150,
  },
  {
    title: $t('operator'),
    dataIndex: 'orderNo',
    key: 'orderNo',
    width: 240,
    render: (text, record) => <div>{record?.operator}</div>,
  },
];
