import React from 'react';
import { Button, Upload } from 'antd';
import { UploadOutlined } from '@ant-design/icons';
import styles from './style.less';

export const payStateEnum = {
  1: { text: $t('pending.application') },
  2: { text: $t('pending.approval') },
  3: { text: $t('approved') },
  4: { text: $t('pending.payout') },
  5: { text: $t('paid.out') },
  6: { text: $t('payment.in.progress.oa.processing') },
  7: { text: $t('payment.in.progress.oa.approved') },
  8: { text: $t('payment.in.progress.pending.transfer') },
};

export const orderStateNum = {
  1: { text: $t('pending.upload') },
  2: { text: $t('pending.review') },
  3: { text: $t('rejected') },
  4: { text: $t('approved') },
};

export const dateStateEnum = {
  1: { text: $t('weekly.settlement') },
  2: { text: $t('halfmonth.settlement') },
  3: { text: $t('monthly.settlement') },
  4: { text: $t('daily.settlement') },
  5: { text: $t('halfday.settlement') },
};

export const redInvoiceState = {
  1: { text: $t('yes'), actionValue: 2 },
  2: { text: $t('no'), actionValue: 1 },
};

export function columns(res, pages) {
  const { current, pageSize } = pages;
  return [
    {
      title: $t('serial.no'),
      dataIndex: 'index',
      hideInSearch: true,
      width: '50px',
      align: 'center',
      render: (text, record, index) => (current - 1) * pageSize + index + 1,
    },
    {
      title: $t('supplier.name'),
      dataIndex: 'supplierName',
      width: '150px',
      hideInSearch: true,
    },
    {
      title: $t('payment.batch.id'),
      dataIndex: 'payBatchNo',
      width: '160px',
      align: 'center',
    },
    {
      title: $t('payment.slip.date'),
      key: 'dateTimeRange',
      dataIndex: 'createdAtRange',
      valueType: 'dateRange',
      width: '120px',
      hideInTable: true,
      initialValue: [],
      align: 'center',
    },
    {
      title: $t('payout.date'),
      key: 'payTimeRange',
      dataIndex: 'payAtRange',
      valueType: 'dateRange',
      width: '120px',
      hideInTable: true,
      initialValue: [],
      align: 'center',
    },
    {
      title: $t('billing.cycle'),
      dataIndex: 'createdAtRange',
      key: 'created',
      hideInSearch: true,
      align: 'center',
      width: '160px',
      render: (text, record) => `${record.billPeriodStart}-${record.billPeriodEnd}`,
    },
    {
      title: $t('payment.slip.date'),
      dataIndex: 'createdAt',
      key: 'createdAt',
      hideInSearch: true,
      align: 'center',
      width: '160px',
    },
    {
      title: $t('total.sales'),
      dataIndex: 'saleAmount',
      width: '100px',
      hideInSearch: true,
      align: 'center',
    },
    {
      title: $t('total.refund'),
      dataIndex: 'refundAmount',
      width: '100px',
      hideInSearch: true,
      align: 'center',
    },
    {
      title: $t('red.amount'),
      dataIndex: 'pastRefundAmount',
      width: '100px',
      hideInSearch: true,
      align: 'center',
    },
    {
      title: () => (
        <div style={{ textAlign: 'center' }}>
          <div>{$t('blue.amount')}</div>
          <div style={{ color: '#f00' }}>{$t('invoice.amount')}</div>
        </div>
      ),
      dataIndex: 'currentRefundAmount',
      key: 'currentRefundAmount',
      width: '100px',
      hideInSearch: true,
      align: 'center',
    },
    {
      title: $t('amount.payable'),
      dataIndex: 'payableAmount',
      width: '140px',
      hideInSearch: true,
      align: 'center',
      render: (value, row) => (
        <div>
          <div>{row.payableAmount}</div>
          <div style={{ color: '#f00' }}>{$t('compensation')}{row.claimAmount})</div>
          <div>{$t('actual.payment')}{row.needPayAmount})</div>
        </div>
      ),
    },
    {
      title: () => (
        <div style={{ textAlign: 'center' }}>
          <div>{$t('current.settlement.cycle')}</div>
          <div style={{ color: '#f00' }}>{$t('supplier.dimension')}</div>
        </div>
      ),
      dataIndex: 'billPeriod',
      key: 'billPeriod',
      width: '150px',
      hideInSearch: true,
      valueEnum: dateStateEnum,
      align: 'center',
    },
    {
      title: () => (
        <div style={{ textAlign: 'center' }}>
          <div>{$t('overdue.amount')}</div>
          <div style={{ color: '#f00' }}>{$t('supplier.dimension')}</div>
        </div>
      ),
      dataIndex: 'arrearsAmount',
      key: 'arrearsAmount',
      width: '130px',
      hideInSearch: true,
      align: 'center',
    },
    {
      title: $t('actual.payment'),
      dataIndex: 'paidAmount',
      key: 'paidAmount',
      width: '100px',
      hideInSearch: true,
      align: 'center',
    },
    {
      title: $t('missing.red.invoice'),
      dataIndex: 'redInvoiceState',
      valueEnum: redInvoiceState,
      align: 'center',
      width: 100,
    },
    {
      title: $t('payment.status'),
      dataIndex: 'payState',
      valueEnum: payStateEnum,
      width: '110px',
      align: 'center',
    },
    {
      title: $t('invoice.status'),
      dataIndex: 'blueInvoiceState',
      valueEnum: orderStateNum,
      width: '110px',
      align: 'center',
    },
    {
      title: $t('actions'),
      dataIndex: 'option',
      // valueType: 'option',
      key: 'option',
      width: '220px',
      align: 'center',
      fixed: 'right',
      render: (_, row) => (
        <div>
          {res.canEditable ? (
            <>
              <Button
                type="primary"
                disabled={row.payState !== 1}
                className={styles.button}
                onClick={() => res.edit(0, row)}
              >{$t('request.settlement')}</Button>
              {(row.billPeriod === 4 || row.billPeriod === 5) && row.blueInvoiceState === 4 ? (
                <Button type="primary" className={styles.button} onClick={() => res.edit(11, row)}>{$t('supplement.invoice')}</Button>
              ) : (
                <Button
                  type="primary"
                  disabled={
                    !(
                      (row.blueInvoiceState === 1 || row.blueInvoiceState === 3) &&
                      row.payState === 3
                    )
                  }
                  className={styles.button}
                  onClick={() => res.edit(1, row)}
                >{$t('upload.invoice')}</Button>
              )}
            </>
          ) : (
            ''
          )}
          <Button
            type="primary"
            disabled={row.blueInvoiceState === 1}
            className={styles.button}
            onClick={() => res.edit(2, row)}
          >{$t('view.invoice')}</Button>
          <Button type="primary" className={styles.button} onClick={() => res.edit(3, row)}>{$t('download.bill')}</Button>
          <Button
            type="primary"
            className={styles.btnMax}
            disabled={row.payState !== 5}
            onClick={() => res.onPaymentOrder(1, row)}
          >{$t('view.payment.proof')}</Button>
        </div>
      ),
    },
  ];
}

export const toolBarRender = onExport => () => [];

// 上传文件
export function uploadPropsFn({
  keyName,
  limit = 1,
  maxSize = 1024 * 1024 * 5,
  maxSizeMsg = $t('max.file.size.5m'),
  form,
  disabled,
  accept = '.png,.bmp,.gif,.jpeg,.jpg',
}) {
  const config = {
    maxSize,
    disabled,
    multiple: limit > 1,
    listType: 'picture-card',
    showUploadList: true,
    accept,
    onRemove: e => {
      const fileValue = form.getFieldValue(keyName) || [];
      if (fileValue.fileList) {
        const files = fileValue.fileList.filter(item => item.uid !== e.uid);
        form.setFieldValue(keyName, files);
      } else {
        const files = fileValue.filter(item => item.uid !== e.uid);
        form.setFieldValue(keyName, files);
      }
    },
  };
  return config;
}

/**
 * 付款单弹窗
 * status：1查看 0上传
 * * */
export const paymentInfoColumn = status => [
  {
    title: $t('payment.slip'),
    dataIndex: 'images',
    key: 'images',
    formItemProps: {
      rules: [{ required: true, message: $t('upload.payment.bill') }],
    },
    fieldProps: {
      disabled: status === 1,
      limit: 1,
      accept: '.png,.bmp,.gif,.jpeg,.jpg,.pdf',
    },
    renderFormItem: (s, c, form) => {
      let fileList = form.getFieldValue('images') || [];
      if (fileList.fileList) {
        fileList = fileList.fileList || [];
      }
      return (
        <Upload
          {...uploadPropsFn.call(this, {
            keyName: 'images',
            form,
            accept: '.png,.bmp,.gif,.jpeg,.jpg,.pdf',
          })}
          fileList={fileList}
          disabled={status === 1}
        >
          <UploadOutlined />{$t('upload.file')}</Upload>
      );
    },
  },
  {
    title: $t('remark'),
    dataIndex: 'comment',
    key: 'comment',
    align: 'center',
    valueType: 'textarea',
    fieldProps: {
      disabled: status === 1,
      maxLength: 200,
      autoSize: { minRows: 2, maxRows: 6 },
    },
  },
];

export const formItemLayout = {
  labelCol: { span: 6 },
  wrapperCol: { span: 18 },
};
