import React, { useState } from 'react';
import { Modal } from 'antd';
import style from '../styles.less';

export default props => {
  const { visible, onCancel, data } = props;
  const [detailModal, setDetailModal] = useState(false);
  const [detailSrc, setDetailSrc] = useState(null);
  const handleCancel = () => {
    onCancel();
  };
  const clickImg = src => {
    setDetailSrc(src);
    setDetailModal(true);
  };
  return (
    <Modal title={$t('aftersales.proof')} visible={visible} onCancel={handleCancel} footer={null} width={600}>
      <div className={style.proofsWrap}>
        {data.map(item => (
          <img
            src={item}
            key={item}
            alt={item}
            className={style.proofs}
            width={250}
            onClick={() => clickImg(item)}
          />
        ))}
      </div>
      <Modal
        title={$t('proof.details')}
        visible={detailModal}
        onCancel={() => setDetailModal(false)}
        footer={null}
        width={700}
      >
        <p className={style.detailWrap}>
          <img src={detailSrc} alt={detailSrc} />
        </p>
      </Modal>
    </Modal>
  );
};
