import React from 'react';
import { Divider, Popconfirm } from 'antd';

export const getColumns = props => {
  const { onDeleteRole, toRoleInfo, canEditable } = props;
  return [
    {
      title: $t('role.id'),
      dataIndex: 'id',
      hideInTable: true,
    },
    {
      title: $t('role.name'),
      dataIndex: 'name',
    },
    {
      title: $t('role.description'),
      dataIndex: 'description',
      hideInSearch: true,
    },
    {
      title: $t('status'),
      dataIndex: 'status',
      hideInSearch: true,
      render: value => value.name,
    },
    {
      title: $t('linked.account'),
      dataIndex: 'userCount',
      hideInSearch: true,
    },
    {
      title: $t('created.by'),
      dataIndex: 'creator',
      hideInSearch: true,
    },
    {
      title: $t('creation.date'),
      hideInSearch: true,
      dataIndex: 'createTime',
    },
    {
      title: $t('actions'),
      key: 'action',
      hideInSearch: true,
      render: (value, record) => {
        if (!canEditable) {
          return '-';
        }
        return (
          <>
            <a onClick={() => toRoleInfo(record)}>{$t('edit')}</a>
            {record.userCount === 0 ? (
              <>
                <Divider type="vertical" />
                <Popconfirm
                  placement="top"
                  title={$t('confirm.delete.role')}
                  onConfirm={() => onDeleteRole(record)}
                  okText={$t('confirm')}
                  cancelText={$t('cancel')}
                >
                  <a>{$t('delete')}</a>
                </Popconfirm>
              </>
            ) : (
              ''
            )}
          </>
        );
      },
    },
  ];
};
