import React, { useRef, useState, useEffect } from 'react';
import { UploadOutlined } from '@ant-design/icons';
import { Modal, Button, Tabs, Upload, notification } from 'antd';
import styles from '../style.less';
import { uploadFile, uploadPic } from '../service';
import UploadC from '../../components/upload';

const { Dragger } = Upload;

const { TabPane } = Tabs;
export default props => {
  const { visible, settlementNo } = props;
  const [tabValue, setTabValue] = useState('1');
  const [fileList, setFileList] = useState([]);
  const picUpload = useRef();
  const uploadProps = {
    name: 'file',
    beforeUpload(file) {
      setFileList([file]);
      return false;
    },
    accept: '.xlsx,.xls,.csv',
    showUploadList: true,
    maxCount: 1,
    fileList,
    onRemove() {
      setFileList([]);
    },
  };
  const initPicUpload = () => {
    if (picUpload?.current?.clearFileList) {
      picUpload.current.clearFileList();
    }
  };
  useEffect(() => {
    initPicUpload();
    setFileList([]);
  }, [visible]);
  const uploadPicFn = async () => {
    // 上传图片的接口
    const upLoadFileList = picUpload?.current?.getFileList?.();
    if (!upLoadFileList.length) {
      notification.warning({ message: $t('upload.images.first') });
      return;
    }
    const data = await uploadPic({
      imgUrl: upLoadFileList.join(','),
      settlementNo,
    });
    if (data.code === '0000') {
      notification.success({ message: $t('upload.successful') });
      initPicUpload();
    }
  };
  const uploadFileFn = async () => {
    if (!fileList.length) {
      notification.warning({ message: $t('upload.attachments.first') });
      return;
    }
    const result = await uploadFile(fileList[0], settlementNo);
    if (result.businessCode === '0000') {
      notification.success({ message: $t('import.success') });
      setFileList([]);
    }
  };
  const uploadFn = () => {
    if (tabValue === '1') {
      uploadPicFn();
    } else {
      uploadFileFn();
    }
  };
  const changeTab = tabV => {
    setTabValue(tabV);
  };
  return (
    <Modal title={$t('upload.invoice')} visible={visible} footer={null} onCancel={props.onCancel} width="700px">
      <Tabs defaultActiveKey="1" className={styles.tab} onChange={changeTab} activeKey={tabValue}>
        <TabPane tab={$t('upload.proof')} key="1">
          <UploadC ref={picUpload} />
        </TabPane>
        <TabPane tab={$t('upload.attachment')} key="2">
          <a
            href="https://kdspstatic.q-gp.com/%E5%8F%91%E7%A5%A8%E4%B8%8A%E4%BC%A0%E6%A8%A1%E6%9D%BF.xlsx"
            className={styles.down}
          >{$t('template.download')}</a>
          <Dragger {...uploadProps} className={styles.clearfloat}>
            <p>
              <UploadOutlined />
            </p>
            <p>{$t('click.to.upload.attachment')}</p>
          </Dragger>
        </TabPane>
      </Tabs>
      <Button type="primary" onClick={uploadFn} className={styles.logBtn}>
        {tabValue === '1' ? $t('confirm.upload.image') : $t('confirm.upload.attachment')}
      </Button>
    </Modal>
  );
};
