import React from 'react';
import { Modal, Row, Col } from 'antd';

const AppealDetail = props => {
  const { modalVisible, onCancel, data } = props;
  return (
    <Modal
      destroyOnClose
      title={$t('view.details')}
      width="800px"
      visible={modalVisible}
      onCancel={() => onCancel()}
      onOk={() => onCancel()}
      bodyStyle={{ maxHeight: '600px', minHeight: '200px', overflow: 'auto' }}
      footer={[]}
    >
      {data ? (
        <div>
          <Row gutter={[10, 20]}>
            <Col span={12}>
              <p>{$t('appeal.id')}{data.appealNo}</p>
            </Col>
            <Col span={12}>
              <p>{$t('order.id')}{data.orderNo}</p>
            </Col>
          </Row>
          <Row gutter={[10, 20]}>
            <Col span={12}>
              <p>{$t('aftersales.id')}{data.serviceNo}</p>
            </Col>
            <Col span={12}>
              <p>{$t('merchant.name')}{data.merchantName}</p>
            </Col>
          </Row>
          <Row gutter={[10, 20]}>
            <Col span={12}>
              <p>{$t('vendor.phone')}{data.merchantPhone}</p>
            </Col>
            <Col span={12}>
              <p>{$t('return.address')}{data.merchantAddress}</p>
            </Col>
          </Row>
          <hr style={{ border: 'none', borderTop: '1px solid #eee', margin: '30px 0' }} />
          <Row type="flex" gutter={[10, 20]}>
            <Col span={13}>
              <p>{$t('approve.aftersales')}{data.isAgree}</p>
            </Col>
          </Row>
          <Row type="flex" gutter={[10, 20]} style={{ marginBottom: '10px' }}>
            <Col span={4}>{$t('rejection.reason')}</Col>
            <Col span={20}>
              <p style={{ width: '70%', marginLeft: '-25px' }}> {data.serviceReason}</p>
            </Col>
          </Row>

          <Row type="flex" justify="start" align="middle" gutter={[10, 20]}>
            <Col span={12}>{$t('dispute.description')}{data.disputeDesc}</Col>
            {/* <Col span={16}>
              <TextArea value={data.disputeDesc} />
            </Col> */}
          </Row>
          <hr style={{ border: 'none', borderTop: '1px solid #eee', margin: '30px 0' }} />

          <Row type="flex" align="middle" gutter={[10, 20]} style={{ minHeight: '100px' }}>
            <Col>{$t('aftersales.proof')}</Col>
            {data.proofs &&
              data.proofs.split(',').map(item => (
                <Col key={item} span={4}>
                  <img key={item} width="100%" src={item} alt="" />
                </Col>
              ))}
          </Row>
          <Row
            type="flex"
            justify="start"
            align="middle"
            gutter={[10, 20]}
            style={{ minHeight: '100px' }}
          >
            <Col span={3}>{$t('supplements')}</Col>
            {data.supplement &&
              data.supplement.split(',').map(item => (
                <Col key={item} span={8}>
                  <img width="100%" src={item} key={item} alt="" />
                </Col>
              ))}
          </Row>
          <hr style={{ border: 'none', borderTop: '1px solid #eee', margin: '30px 0' }} />
          <Row type="flex" justify="start" align="middle" gutter={[10, 20]}>
            <Col span={3}>{$t('negotiation.result')}</Col>
            <Col span={8}>{+data.appealResult === 1 ? $t('agree') : $t('disagree')}</Col>
          </Row>
          {+data.appealResult === 2 && (
            <Row type="flex" justify="start" align="middle" gutter={[10, 20]}>
              <Col span={5}>{$t('rejection.reason')}</Col>
              <Col span={10} style={{ marginLeft: '-20px' }}>
                {data.refuseReason}
              </Col>
            </Row>
          )}
          {+data.appealResult === 1 && [
            <Row type="flex" justify="start" align="middle" gutter={[10, 30]}>
              <Col span={4}>{$t('return.address')}</Col>
              <Col span={16}>{data.merchantAddress}</Col>
            </Row>,
            <Row type="flex" justify="start" align="middle" gutter={[10, 20]}>
              <Col span={3}>{$t('vendor.name')}</Col>
              <Col span={8}>{data.merchantAddress}</Col>
              <Col span={3}>{$t('vendor.phone')}</Col>
              <Col span={8}>{data.merchantPhone}</Col>
            </Row>,
          ]}
        </div>
      ) : (
        $t('no.details.available')
      )}
    </Modal>
  );
};

export default AppealDetail;
