import { Modal, Button, Row, Col } from 'antd';
import React, { Component } from 'react';

// eslint-disable-next-line react/prefer-stateless-function
class imgModal extends Component {
  state = {
    imgModal: false,
    selectImg: '',
  };

  render() {
    const { modalVisible, title, imgData = [] } = this.props;
    return (
      <Modal
        title={title}
        visible={modalVisible}
        footer={null}
        onCancel={this.props.onCancel}
        width="550px"
        bodyStyle={{ minHeight: '150px', textAlign: 'center' }}
      >
        <Row type="flex" justify="center" align="middle" gutter={20}>
          {imgData.map(item => (
            <Col key={item}>
              <img
                onClick={() => {
                  this.setState({ imgModal: true, selectImg: item });
                }}
                key={item}
                width={150}
                alt=""
                src={item}
              ></img>
            </Col>
          ))}
        </Row>
        <Button type="primary" onClick={this.props.onCancel} style={{ margin: 100 }}>{$t('cancel')}</Button>
        <Modal
          title={$t('attachment.details')}
          visible={this.state.imgModal}
          footer={null}
          onCancel={() => this.setState({ imgModal: false })}
          width="800px"
          style={{ textAlign: 'center' }}
        >
          <img width="700px" src={this.state.selectImg} alt=""></img>
        </Modal>
      </Modal>
    );
  }
}

export default imgModal;
