import React from 'react';
import { Form } from '@ant-design/compatible';
import '@ant-design/compatible/assets/index.css';
import { Modal, Row, Col, Input, Select, notification } from 'antd';
import { audit } from '../appeal/services';

const { TextArea } = Input;
const FormItem = Form.Item;
const { Option } = Select;

const AuditModal = props => {
  const {
    modalVisible,
    onCancel,
    data,
    form: { getFieldDecorator, getFieldValue, validateFields, resetFields },
  } = props;

  const handleOk = () => {
    // 掉接口
    // 成功后掉取消接口
    validateFields(async (error, fieldsValue) => {
      if (!error) {
        const auditData = await audit({
          ...fieldsValue,
          appealNo: data.appealNo,
        });
        if (auditData && auditData.code === '0000') {
          notification.success({ message: $t('review.success') });
          resetFields();
          onCancel(true);
        }
      }
    });
  };
  const layout = {
    labelCol: { span: 3 },
    wrapperCol: { span: 15 },
  };
  const isAgree = () => getFieldValue('appealResult') === '1';
  const isRefuse = () => getFieldValue('appealResult') && getFieldValue('appealResult') !== '1';
  return (
    <Modal
      destroyOnClose
      title={$t('order.review')}
      width="800px"
      visible={modalVisible}
      onCancel={() => onCancel()}
      onOk={() => handleOk()}
      bodyStyle={{ maxHeight: '800px', minHeight: '200px', overflow: 'auto' }}
    >
      {data ? (
        <div>
          <Row gutter={[10, 20]}>
            <Col span={12}>
              <p>{$t('appeal.id')}{data.appealNo}</p>
            </Col>
            <Col span={12}>
              <p>{$t('order.id')}{data.orderNo}</p>
            </Col>
          </Row>
          <Row gutter={[10, 20]}>
            <Col span={12}>
              <p>{$t('aftersales.id')}{data.serviceNo}</p>
            </Col>
            <Col span={12}>
              <p>{$t('merchant.name')}{data.merchantName}</p>
            </Col>
          </Row>
          <Row gutter={[10, 20]}>
            <Col span={12}>
              <p>{$t('vendor.phone')}{data.merchantPhone}</p>
            </Col>
            <Col span={12}>
              <p>{$t('return.address')}{data.merchantAddress}</p>
            </Col>
          </Row>
          <hr style={{ border: 'none', borderTop: '1px solid #eee', margin: '30px 0' }} />
          <Row type="flex" gutter={[10, 20]}>
            <Col span={13}>
              <p>{$t('approve.aftersales')}{data.isAgree}</p>
            </Col>
          </Row>
          <Row type="flex" gutter={[10, 20]} style={{ marginBottom: '10px' }}>
            <Col span={4}>{$t('rejection.reason')}</Col>
            <Col span={20}>
              <p style={{ width: '70%', marginLeft: '-25px' }}> {data.serviceReason}</p>
            </Col>
          </Row>

          <Row type="flex" justify="start" align="middle" gutter={[10, 20]}>
            <Col span={12}>{$t('dispute.description')}{data.disputeDesc}</Col>
            {/* <Col span={16}>
              <TextArea value={data.disputeDesc} />
            </Col> */}
          </Row>
          <hr style={{ border: 'none', borderTop: '1px solid #eee', margin: '30px 0' }} />

          <Row type="flex" align="middle" gutter={[10, 20]} style={{ minHeight: '100px' }}>
            <Col>{$t('aftersales.proof')}</Col>
            {data.proofs &&
              data.proofs.split(',').map(item => (
                <Col key={item} span={4}>
                  <img key={item} width="100%" src={item} alt="" />
                </Col>
              ))}
          </Row>
          <Row
            type="flex"
            justify="start"
            align="middle"
            gutter={[10, 20]}
            style={{ minHeight: '100px' }}
          >
            <Col span={3}>{$t('supplements')}</Col>
            {data.supplement &&
              data.supplement.split(',').map(item => (
                <Col key={item} span={8}>
                  <img width="100%" src={item} key={item} alt="" />
                </Col>
              ))}
          </Row>
          <hr style={{ border: 'none', borderTop: '1px solid #eee', margin: '30px 0' }} />
          <Row gutter={[10, 20]}>
            <Form {...layout} name="formData">
              <FormItem label={$t('review.result')}>
                {getFieldDecorator('appealResult')(
                  <Select placeholder={$t('select.audit.result')}>
                    <Option value="1">{$t('agree')}</Option>
                    <Option value="2">{$t('disagree')}</Option>
                  </Select>,
                )}
              </FormItem>
              {isAgree() && (
                <div>
                  <FormItem label={$t('return.address')}>
                    {getFieldDecorator('receiveAddress', {
                      rules: [
                        {
                          required: true,
                          message: $t('enter.return.address'),
                        },
                        {
                          message: $t('invalid.format.enter.correct.return.address'),
                          pattern: /[a-zA-Z0-9_\u4e00-\u9fa5]/g,
                        },
                      ],
                    })(<Input placeholder={$t('max.50.characters')} maxLength="50" allowClear />)}
                  </FormItem>
                  <FormItem label={$t('recipient')}>
                    {getFieldDecorator('receiverName', {
                      rules: [
                        {
                          required: true,
                          message: $t('enter.recipient'),
                        },
                        {
                          message: $t('invalid.format.enter.chineseenglishdigits'),
                          pattern: /^[A-Za-z0-9\u4e00-\u9fa5]+$/,
                        },
                      ],
                    })(<Input placeholder={$t('max.25.characters')} maxLength="25" allowClear />)}
                  </FormItem>
                  <FormItem label={$t('mobile.number')}>
                    {getFieldDecorator('receiverPhone', {
                      rules: [
                        {
                          pattern: new RegExp(/^1[3456789]\d{9}$/, 'g'),
                          message: $t('invalid.phone.format'),
                        },
                        {
                          required: true,
                          message: $t('enter.phone.number'),
                        },
                      ],
                    })(<Input placeholder={$t('11.digits')} maxLength="11" allowClear />)}
                  </FormItem>
                </div>
              )}
              {isRefuse() && (
                <FormItem label={$t('rejection.reason')}>
                  {getFieldDecorator('refuseReason', {
                    rules: [
                      {
                        required: true,
                        message: $t('enter.rejection.reason'),
                      },
                    ],
                  })(
                    <TextArea
                      placeholder={$t('enter.rejection.reason')}
                      allowClear
                      autoSize={{ minRows: 3, maxRows: 6 }}
                    />,
                  )}
                </FormItem>
              )}
            </Form>
          </Row>
        </div>
      ) : (
        $t('no.details.available')
      )}
    </Modal>
  );
};

export default Form.create()(AuditModal);
