import { Button, Tag } from 'antd';
import React from 'react';

export const refuseReasonEnum = {
  0: { text: $t('pending.action') },
  1: { text: $t('agreed') },
  2: { text: $t('rejected') },
};

export function columns(res) {
  const { openAudit, openDetail, openImgModal } = res;
  return [
    {
      title: $t('aftersales.appeal.id'),
      width: 300,
      dataIndex: 'appealNo',
      key: 'appealNo',
      // eslint-disable-next-line no-confusing-arrow
      render: (appealNo, row) =>
        row.timeout ? (
          <Tag color="red" key={appealNo}>
            {appealNo}
          </Tag>
        ) : (
          appealNo
        ),
    },
    {
      title: $t('aftersales.id'),
      width: 300,
      dataIndex: 'serviceNo',
      key: 'serviceNo',
    },
    {
      title: $t('order.id'),
      width: 200,
      dataIndex: 'orderNo',
      key: 'orderNo',
    },
    {
      title: $t('appeal.start.time'),
      width: 120,
      dataIndex: 'startDate',
      key: 'startDate',
      valueType: 'date',
      hideInTable: true,
    },
    {
      title: $t('appeal.end.time'),
      width: 120,
      dataIndex: 'endDate',
      key: 'endDate',
      valueType: 'date',
      hideInTable: true,
    },
    {
      title: $t('merchant.name'),
      width: 120,
      dataIndex: 'merchantName',
      key: 'merchantName',
      hideInSearch: true,
    },
    {
      title: $t('merchant.phone'),
      width: 120,
      dataIndex: 'merchantPhone',
      key: 'merchantPhone',
      hideInSearch: true,
    },
    {
      title: $t('merchant.refund.address'),
      width: 120,
      dataIndex: 'merchantAddress',
      key: 'merchantAddress',
      hideInSearch: true,
    },
    {
      title: $t('approve.aftersale'),
      width: 120,
      dataIndex: 'isAgree',
      key: 'isAgree',
      hideInSearch: true,
    },
    {
      title: $t('merchant.rejection.reason'),
      width: 120,
      dataIndex: 'serviceReason',
      key: 'serviceReason',
      hideInSearch: true,
    },
    {
      title: $t('aftersales.proof'),
      width: 120,
      dataIndex: 'proofs',
      key: 'proofs',
      hideInSearch: true,
      render: (_, row) => (
        // const list = proofs && proofs !== '-' ? proofs.split(',') : [];
        <a onClick={() => openImgModal(row.proofs)}>{$t('view.proof')}</a>
      ),
    },
    {
      title: $t('appeal.creation.time'),
      width: 120,
      dataIndex: 'appealTime',
      key: 'appealTime',
      hideInSearch: true,
    },
    {
      title: $t('appeal.timeout'),
      width: 120,
      dataIndex: 'overtime',
      key: 'overtime',
      hideInSearch: true,
    },
    {
      title: $t('dispute.description'),
      width: 120,
      dataIndex: 'disputeDesc',
      key: 'disputeDesc',
      hideInSearch: true,
    },
    {
      title: $t('supplementary.materials'),
      width: 120,
      dataIndex: 'supplement',
      key: 'supplement',
      hideInSearch: true,
      render: (_, row) => (
        // const list = supplement && supplement !== '-' ? supplement.split(',') : [];
        <a onClick={() => openImgModal(row.supplement)}>{$t('view.supplements')}</a>
      ),
    },
    {
      title: $t('negotiation.result'),
      width: 120,
      dataIndex: 'appealResult',
      key: 'appealResult',
      hideInSearch: true,
      valueEnum: refuseReasonEnum,
    },
    {
      title: $t('aftersales.appeal.rejection.reason'),
      width: 120,
      dataIndex: 'refuseReason',
      key: 'refuseReason',
      hideInSearch: true,
    },
    {
      title: $t('actions'),
      width: 220,
      dataIndex: 'option',
      valueType: 'option',
      key: 'option',
      render: (_, row) => [
        <Button disabled={!row.showAudit} type="primary" onClick={() => openAudit(row)}>{$t('review')}</Button>,
        <Button disabled={!row.showDetail} type="primary" onClick={() => openDetail(row)}>{$t('view.details')}</Button>,
      ],
    },
  ];
}
