import React, { useState, forwardRef, useImperativeHandle, useEffect } from 'react';
import { Modal, Timeline, notification, Spin, Collapse } from 'antd';
import { apiDeliveriesTraceList } from '../services';
import styles from '../index.less';

const { Panel } = Collapse;

const LogisticsRecordModal = (props, ref) => {
  // const { } = props;

  const [visible, setVisible] = useState(false);
  const [loading, setLoading] = useState(false);
  const [dataList, setDataList] = useState([]);
  const [isSingle, setIsSingle] = useState(false);

  const getRecordList = async params => {
    setLoading(true);
    const res = await apiDeliveriesTraceList(params);
    setLoading(false);
    if (!res) {
      notification.info({ message: $t('no.logistics.info') });
      return;
    }

    setDataList(res.data);
  };

  const open = (record, type) => {
    setVisible(true);
    getRecordList(record);
    if (type === 'single') {
      setIsSingle(true);
    }
  };
  const onCancel = () => {
    setVisible(false);
    setTimeout(() => {
      setDataList([]);
    }, 1000);
  };
  useImperativeHandle(ref, () => ({
    open,
  }));

  const modalProps = {
    title: $t('view.logistics'),
    visible,
    onCancel,
    destroyOnClose: true,
    bodyStyle: { maxHeight: '600px', minHeight: '200px', overflow: 'auto' },
    footer: null,
  };
  const emptyStyle = {
    textAlign: 'center',
    padding: '30px 0',
    color: '#999',
  };

  return (
    <Modal {...modalProps}>
      <Spin spinning={loading}>
        {dataList.length ? (
          dataList.map((dataItem, dataIndex) => (
            <div className={styles['logistics-record']}>
              {!isSingle ? (
                <div className={styles['logistics-record__topbar']}>{$t('parcel')}{dataIndex + 1}</div>
              ) : (
                ''
              )}
              <div className={styles['logistics-record__head']}>
                <span className={styles.name}>{$t('logistics.company')}{dataItem.expressCompanyName}</span>
                <span className={styles.no}>{$t('tracking.number')}{dataItem.expressNo}</span>
              </div>
              {dataItem.traceList.map(traceItem => (
                <Timeline>
                  {traceItem?.detailList.length ? (
                    traceItem?.detailList?.map((item, index) => (
                      <Timeline.Item color={index > 0 ? 'gray' : 'blue'} key={index.toString()}>
                        <p>{item.desc}</p>
                        <p>{item.time}</p>
                      </Timeline.Item>
                    ))
                  ) : (
                    <div style={emptyStyle}>{$t('no.logistics.info')}</div>
                  )}
                </Timeline>
              ))}
            </div>
          ))
        ) : (
          <div style={emptyStyle}>{$t('no.logistics.info')}</div>
        )}

        {/* 折叠 */}
        {/* <Collapse defaultActiveKey={['0']} ghost >
          {dataList.length ? (
            dataList.map((dataItem, dataIndex) => (
              <Panel showArrow={false} header={<div className={styles['logistics-record__topbar']}>包裹{dataIndex + 1}</div>} key={dataIndex.toString()}>
              <div className={styles['logistics-record']}>

                <div className={styles['logistics-record__head']}>
                  <span className={styles.name}>物流公司：{dataItem.expressCompanyName}</span>
                  <span className={styles.no}>物流单号：{dataItem.expressNo}</span>
                </div>
                {dataItem.traceList.map(traceItem => (
                  <Timeline>
                    {traceItem?.detailList.length ? (
                      traceItem?.detailList?.map((item, index) => (
                        <Timeline.Item color={index > 0 ? 'gray' : 'blue'} key={index.toString()}>
                          <p>{item.desc}</p>
                          <p>{item.time}</p>
                        </Timeline.Item>
                      ))
                    ) : (
                      <div style={emptyStyle}>暂无物流信息</div>
                    )}
                  </Timeline>
                ))}
              </div>
              </Panel>
            ))
          ) : (
            <div style={emptyStyle}>暂无物流信息</div>
          )}
        </Collapse> */}
      </Spin>
    </Modal>
  );
};

export default forwardRef(LogisticsRecordModal);
