import { DownloadOutlined } from '@ant-design/icons';
import { Modal, Button, Empty, Pagination } from 'antd';
import React, { useState, useEffect } from 'react';
import { unstable_batchedUpdates } from 'react-dom';
import styles from './index.less';
import { apiUploadResult } from './service';

const ImportListModal = props => {
  const { visible } = props;
  const [data, setData] = useState([]);
  const [total, setTotal] = useState(0);
  const [pageInfo, setPageInfo] = useState({
    pageNo: 1,
    pageSize: 2,
  });

  const getImportData = async params => {
    const res = await apiUploadResult({
      type: props.type,
      ...params,
    });
    if (res?.data) {
      unstable_batchedUpdates(() => {
        setData(res.data.records);
        setTotal(res.data.total);
      });
    }
  };

  const onChangePage = (pageNo, pageSize) => {
    const obj = { pageNo, pageSize };
    setPageInfo(obj);
    getImportData(obj);
  };

  const onDownload = url => {
    window.location.href = url;
  };

  useEffect(() => {
    getImportData(pageInfo);
  }, []);
  return (
    <Modal
      title={
        <div>{$t('view.import.history')}<span className={styles.subTitle}>{$t('last.6.months.only')}</span>
        </div>
      }
      open={visible}
      onCancel={props.onCancel}
      width="800px"
      footer={false}
    >
      {data.length ? (
        <div>
          <div className={styles.tableBody}>
            {data.map(item => (
              <div className={styles.card} key={item.id}>
                <div>
                  <div className={styles.top}>
                    <span>{$t('imported.data')}{item.total}</span>
                    <span>{$t('successful')}{item.successCount}</span>
                    <span>{$t('failed')}{item.failedCount}</span>
                  </div>
                  <div>
                    <span>{$t('import.time')}{item.createdAt}</span>
                    <span>{$t('operator')}{item.createdBy}</span>
                  </div>
                </div>
                <div className={styles.errWrappper}>
                  {item.failedCount > 0 && (
                    <Button type="primary" onClick={() => onDownload(item.failedFileUrl)}>
                      <DownloadOutlined />{$t('download.error.data')}</Button>
                  )}
                  {item.status && +item.status.code === 3 && (
                    <div className={styles.errorMessage}>{item.failedMessage}</div>
                  )}
                </div>
              </div>
            ))}
          </div>
          <div className={styles.pagewrapper}>
            <Pagination
              total={total}
              showTotal={e => `总共 ${e} 条数据`}
              pageSize={pageInfo.pageSize}
              defaultCurrent={pageInfo.pageNo}
              onChange={onChangePage}
              onShowSizeChange={onChangePage}
              showQuickJumper
              // showSizeChanger
            />
          </div>
        </div>
      ) : (
        <Empty />
      )}
    </Modal>
  );
};

export default ImportListModal;
