function getFakeCaptcha(req, res) {
  return res.json('captcha-xxx');
} // 代码中会兼容本地 service mock 以及部署站点的静态数据

export default {
  // 支持值为 Object 和 Array
  'GET /api/currentUser': {
    name: 'Serati Ma',
    avatar: 'https://gw.alipayobjects.com/zos/antfincdn/XAosXuNZyF/BiazfanxmamNRoxxVxka.png',
    userid: '00000001',
    email: 'antdesign@alipay.com',
    signature: $t('inclusion.leads.to.greatness'),
    title: $t('interaction.expert'),
    group: $t('ant.group.xxx.business.unit.yyy.platform.zzz.tech.ued'),
    tags: [
      {
        key: '0',
        label: $t('creative'),
      },
      {
        key: '1',
        label: $t('design.focused'),
      },
      {
        key: '2',
        label: $t('spicy'),
      },
      {
        key: '3',
        label: $t('long.legs'),
      },
      {
        key: '4',
        label: $t('sichuan.girl'),
      },
      {
        key: '5',
        label: $t('all.rivers.run.into.sea'),
      },
    ],
    notifyCount: 12,
    unreadCount: 11,
    country: 'China',
    geographic: {
      province: {
        label: $t('zhejiang.province'),
        key: '330000',
      },
      city: {
        label: $t('hangzhou'),
        key: '330100',
      },
    },
    address: $t('77.gongzhuan.rd.xihu.district'),
    phone: '0752-268888888',
  },
  // GET POST 可省略
  'GET /api/users': [
    {
      key: '1',
      name: 'John Brown',
      age: 32,
      address: 'New York No. 1 Lake Park',
    },
    {
      key: '2',
      name: 'Jim Green',
      age: 42,
      address: 'London No. 1 Lake Park',
    },
    {
      key: '3',
      name: 'Joe Black',
      age: 32,
      address: 'Sidney No. 1 Lake Park',
    },
  ],
  'POST /api/login/account': (req, res) => {
    const { password, userName, type } = req.body;

    if (password === 'ant.design' && userName === 'admin') {
      res.send({
        status: 'ok',
        type,
        currentAuthority: 'admin',
      });
      return;
    }

    if (password === 'ant.design' && userName === 'user') {
      res.send({
        status: 'ok',
        type,
        currentAuthority: 'user',
      });
      return;
    }

    res.send({
      status: 'error',
      type,
      currentAuthority: 'guest',
    });
  },
  'POST /api/register': (req, res) => {
    res.send({
      status: 'ok',
      currentAuthority: 'user',
    });
  },
  'GET /api/500': (req, res) => {
    res.status(500).send({
      timestamp: 1513932555104,
      status: 500,
      error: 'error',
      message: 'error',
      path: '/base/category/list',
    });
  },
  'GET /api/404': (req, res) => {
    res.status(404).send({
      timestamp: 1513932643431,
      status: 404,
      error: 'Not Found',
      message: 'No message available',
      path: '/base/category/list/2121212',
    });
  },
  'GET /api/403': (req, res) => {
    res.status(403).send({
      timestamp: 1513932555104,
      status: 403,
      error: 'Unauthorized',
      message: 'Unauthorized',
      path: '/base/category/list',
    });
  },
  'GET /api/401': (req, res) => {
    res.status(401).send({
      timestamp: 1513932555104,
      status: 401,
      error: 'Unauthorized',
      message: 'Unauthorized',
      path: '/base/category/list',
    });
  },
  'GET  /api/login/captcha': getFakeCaptcha,
  'GET  /api/kdsp/op/order/waiting-for-delivery': (req, res) => {
    res.send({
      code: 2000,
      data: {
        content: [{
          orderNo: '123',
          skuSource: $t('zhonglian'),
          payTime: '2020-10-20',
          receiverName: $t('hao.congmin'),
          receiverPhone: '13718672532',
          receiveAddress: $t('beijing.fangshan.district'),
          status: '1'
        }]
      }
    });
  },
};
