import React from 'react';
import { Button } from 'antd';

export const layout = {
  labelCol: { span: 4 },
  wrapperCol: { span: 18 },
};

// 餐品类型：（1外卖 2 自助餐 4到店）
export const mealType = {
  1: $t('takeaway'),
  2: $t('buffet'),
  4: $t('instore'),
};

export const infoOptions = [
  { label: $t('product.price.image'), value: 1 },
  { label: $t('product.price.only'), value: 2 },
  { label: $t('product.image.only'), value: 3 },
  { label: $t('hide.all'), value: 4 },
];

export const boolOptions = [{ label: $t('yes'), value: 1 }, { label: $t('no'), value: 0 }];
export const hideOptions = [
  { label: $t('hide.product.price'), value: 'hidePrice' },
  { label: $t('hide.product.image'), value: 'hideImage' },
];

export const mealSections = {
  1: $t('breakfast'),
  2: $t('lunch'),
  4: $t('dinner'),
};

// 企业列表字段
export const customerColumn = options => {
  const { onEdit } = options;
  return [
    {
      title: 'ID',
      dataIndex: 'enterpriseId',
      hideInTable: true,
    },
    {
      title: 'ID',
      dataIndex: 'id',
      width: 120,
      align: 'center',
      hideInSearch: true,
    },
    {
      title: $t('company.name'),
      dataIndex: 'name',
      width: 120,
      align: 'center',
    },
    {
      title: $t('cutoff.time.mins'),
      dataIndex: 'endOrderTime',
      width: 120,
      align: 'center',
      hideInSearch: true,
    },
    {
      title: $t('food.type'),
      dataIndex: 'mealType',
      width: 120,
      align: 'center',
      hideInSearch: true,
      render(types) {
        if (types && types.length && typeof types === 'object') {
          const arr = types.map(meal => mealType[meal]);
          return arr.join('/');
        }
        return '-';
      },
    },
    {
      title: $t('created.by'),
      dataIndex: 'createdBy',
      width: 120,
      align: 'center',
      hideInSearch: true,
    },
    {
      title: $t('creation.time'),
      dataIndex: 'createdAt',
      width: 120,
      align: 'center',
      hideInSearch: true,
    },
    {
      title: $t('actions'),
      hideInSearch: true,
      dataIndex: 'action',
      width: 200,
      align: 'center',
      fixed: 'right',
      render: (val, r) => (
        <Button key="edit" onClick={() => onEdit(r.id)}>{$t('edit')}</Button>
      ),
    },
  ];
};
