/* eslint-disable no-confusing-arrow */
export const formItemLayout = {
  labelCol: {
    sm: { span: 3 },
  },
  wrapperCol: {
    sm: { span: 16 },
  },
};

export const TaskList = (canAddService, canAddNormal, canTakeawayService) => [
  {
    name: $t('physical.goods'),
    type: 1,
    desc: $t('logistics.dispatch'),
    hide: !canAddNormal,
    imgConfig: {
      commonImageList: {
        title: $t('public.slider'),
        rule: false,
        limit: null,
        renderExtra: () => $t('max.2mb.image.upload'),
      },
      imageList: {
        rule: false,
        limit: null,
        renderExtra: () => $t('max.2mb.image.upload'),
      },
      detailImageList: {
        title: $t('detail.image'),
        rule: true,
        limit: null,
        renderExtra: () => $t('max.2mb.image.upload'),
      },
    },
  },
  // {
  //   name: '虚拟商品',
  //   type: 2,
  //   desc: '无需物流',
  //   hide: !canAddNormal,
  //   imgConfig: {
  //     commonImageList: {
  //       title: '公共滑动图',
  //       rule: false,
  //       limit: null,
  //       renderExtra: () => '（图片最大上传2M）',
  //     },
  //     imageList: {
  //       rule: false,
  //       limit: null,
  //       renderExtra: () => '（图片最大上传2M）',
  //     },
  //     detailImageList: {
  //       title: '详情图',
  //       rule: true,
  //       limit: null,
  //       renderExtra: () => '（图片最大上传2M）',
  //     },
  //   },
  // },
  {
    name: $t('service.products'),
    type: 4,
    desc: $t('no.logistics.needed'),
    hide: !canAddService,
    imgConfig: {
      commonImageList: {
        title: $t('cover.image'),
        rule: true,
        limit: 1,
        renderExtra(leng) {
          return `建议尺寸: ##宽##高 (${leng} / 1) 封面图第一张 `;
        },
      },
      cardImageList: {
        title: $t('product.image'),
        rule: true,
        limit: 11,
        renderExtra(leng) {
          return `建议尺寸: ##宽##高,sku商品轮播图(${leng} / 11)`;
        },
      },
      detailImageList: {
        title: $t('product.detail.images'),
        // rule: true,
        limit: 30,
        renderExtra() {
          return $t('max.30.uploads');
        },
      },
    },
  },
  {
    name: $t('delivery.products'),
    type: 5,
    desc: $t('no.logistics.needed'),
    hide: !canTakeawayService,
    imgConfig: {
      commonImageList: {
        title: $t('cover.image'),
        rule: true,
        limit: 1,
        renderExtra(leng) {
          return `建议尺寸: ##宽##高 (${leng} / 1) 封面图第一张 `;
        },
      },
      cardImageList: {
        title: $t('product.image'),
        rule: true,
        limit: 11,
        renderExtra(leng) {
          return `建议尺寸: ##宽##高,sku商品轮播图(${leng} / 11)`;
        },
      },
      detailImageList: {
        title: $t('product.detail.images'),
        // rule: true,
        limit: 30,
        renderExtra() {
          return $t('max.30.uploads');
        },
      },
    },
  },
];

export const WeeksList = [
  {
    name: $t('public.holidays'),
    value: 8,
  },
  {
    name: $t('monday'),
    value: 1,
  },
  {
    name: $t('tuesday'),
    value: 2,
  },
  {
    name: $t('wednesday'),
    value: 3,
  },
  {
    name: $t('thursday'),
    value: 4,
  },
  {
    name: $t('friday'),
    value: 5,
  },
  {
    name: $t('saturday'),
    value: 6,
  },
  {
    name: $t('sunday'),
    value: 7,
  },
];
export const StaticColumns = customer => [
  {
    title: $t('supply.price'),
    dataIndex: 'supplyPrice',
    editable: true,
    batchRole: [1, 2, 3, 4],
    roleProps: {
      precision: 2,
      min: 0,
    },
    batchProps: {
      precision: 2,
      min: 0,
    },
    roleRules: { required: true },
    disabeldRender: () => customer.isDisabled,
  },
  {
    title: $t('commission.rate'),
    dataIndex: 'commissionRate',
    editable: true,
    role: [4],
    roleRules: { required: false },
    roleProps: {
      min: 0,
    },
    // batchProps: {
    //   min: 0,
    // },
  },
  {
    title: $t('market.price'),
    dataIndex: 'marketPrice',
    editable: true,
    batchRole: [1, 2, 3, 4],
    roleProps: {
      precision: 2,
      min: 0,
    },
    batchProps: {
      precision: 2,
      min: 0,
    },
    roleRules: { required: true },
    disabeldRender: () => customer.isDisabled,
  },
  {
    title: $t('selling.price'),
    dataIndex: 'salePrice',
    editable: true,
    batchRole: [4],
    role: [4],
    roleRules: { required: true },
    roleProps: {
      precision: 2,
      min: 0,
    },
    batchProps: {
      precision: 2,
      min: 0,
    },
    disabeldRender: () => customer.isDisabled,
  },
  {
    title: `重量(${customer.isGold ? 'g' : 'kg'})`,
    dataIndex: 'weight',
    editable: true,
    batchRole: [1],
    batchProps: {
      min: 0,
      precision: customer.isGold ? 2 : 3,
      max: customer.isGold ? 100 : 999999.999,
    },
    role: [1],
    roleRules: { required: true },
    roleProps: {
      min: 0,
      precision: customer.isGold ? 2 : 3,
      max: customer.isGold ? 100 : 999999.999,
    },
    disabeldRender: () => customer.isDisabled,
  },
  {
    title: $t('inventory'),
    dataIndex: 'productStock',
    editable: true,
    role: [1, 2, 4],
    batchRole: [1, 2, 4],
    batchProps: {
      precision: 0,
      step: 1,
      min: 0,
    },
    roleProps: {
      min: 0,
      step: 1,
      precision: 0,
    },
    roleRules: { required: true },
    disabeldRender: record => {
      if (record.stock === null) return false;
      return customer.isEdit && customer.isNormal;
    },
  },
  {
    title: $t('stock.alert'),
    dataIndex: 'productStockWarning',
    editable: true,
    batchRole: [1],
    role: [1, 4],
    roleProps: {
      min: 0,
      precision: 0,
      maxLength: 5,
    },
    batchProps: {
      min: 0,
      precision: 0,
      maxLength: 5,
    },
    disabeldRender: () => customer.isDisabled,
  },
  {
    title: $t('custom.product.code'),
    dataIndex: 'thirdSkuNo',
    editable: true,
    role: [1, 2],
    inputType: 'input',
    roleRules: { required: true },
    disabeldRender: () => customer.isDisabled,
  },
  {
    title: $t('jd.link'),
    dataIndex: 'skuLink',
    editable: true,
    role: [1, 2],
    inputType: 'input',
    roleRules: { required: false },
    disabeldRender: () => customer.isDisabled,
  },
  {
    title: $t('sku.name'),
    dataIndex: 'name',
    editable: true,
    role: customer.isEdit && customer.isJDGoods ? [1, 2] : [],
    inputType: 'btnText',
    roleRules: { required: false },
    disabeldRender: () => customer.isDisabled,
  },
  {
    title: $t('actions'),
    editable: true,
    dataIndex: 'option',
    role: [1, 2],
    inputType: 'option',
    roleProps: {
      isJDGoods: customer.isJDGoods,
      disabled: customer.isDisabled,
      min: 0,
    },
    roleRules: { required: false },
    disabeldRender: () => customer.isDisabled,
  },
];
// 这部分是用来应付审计团队的,没有实际功能,这里删掉了供货价字段,正常业务逻辑不用考虑这里
export const StaticColumnsPop = customer => [
  {
    title: $t('commission.rate'),
    dataIndex: 'commissionRate',
    editable: true,
    role: [4],
    roleRules: { required: false },
    roleProps: {
      min: 0,
    },
    // batchProps: {
    //   min: 0,
    // },
  },
  {
    title: $t('market.price'),
    dataIndex: 'marketPrice',
    editable: true,
    batchRole: [1, 2, 3, 4],
    roleProps: {
      precision: 2,
      min: 0,
    },
    batchProps: {
      precision: 2,
      min: 0,
    },
    roleRules: { required: true },
    disabeldRender: () => customer.isDisabled,
  },
  {
    title: $t('selling.price'),
    dataIndex: 'salePrice',
    editable: true,
    batchRole: [4],
    role: [4],
    roleRules: { required: true },
    roleProps: {
      precision: 2,
      min: 0,
    },
    batchProps: {
      precision: 2,
      min: 0,
    },
    disabeldRender: () => customer.isDisabled,
  },
  {
    title: `重量(${customer.isGold ? 'g' : 'kg'})`,
    dataIndex: 'weight',
    editable: true,
    batchRole: [1],
    batchProps: {
      min: 0,
      precision: customer.isGold ? 2 : 3,
      max: customer.isGold ? 100 : 999999.999,
    },
    role: [1],
    roleRules: { required: true },
    roleProps: {
      min: 0,
      precision: customer.isGold ? 2 : 3,
      max: customer.isGold ? 100 : 999999.999,
    },
    disabeldRender: () => customer.isDisabled,
  },
  {
    title: $t('inventory'),
    dataIndex: 'productStock',
    editable: true,
    role: [1, 2, 4],
    batchRole: [1, 2, 4],
    batchProps: {
      precision: 0,
      step: 1,
      min: 0,
    },
    roleProps: {
      min: 0,
      step: 1,
      precision: 0,
    },
    roleRules: { required: true },
    disabeldRender: record => {
      if (record.stock === null) return false;
      return customer.isEdit && customer.isNormal;
    },
  },
  {
    title: $t('stock.alert'),
    dataIndex: 'productStockWarning',
    editable: true,
    batchRole: [1],
    role: [1, 4],
    roleProps: {
      min: 0,
      precision: 0,
      maxLength: 5,
    },
    batchProps: {
      min: 0,
      precision: 0,
      maxLength: 5,
    },
    disabeldRender: () => customer.isDisabled,
  },
  {
    title: $t('custom.product.code'),
    dataIndex: 'thirdSkuNo',
    editable: true,
    role: [1, 2],
    inputType: 'input',
    roleRules: { required: true },
    disabeldRender: () => customer.isDisabled,
  },
  {
    title: $t('jd.link'),
    dataIndex: 'skuLink',
    editable: true,
    role: [1, 2],
    inputType: 'input',
    roleRules: { required: false },
    disabeldRender: () => customer.isDisabled,
  },
  {
    title: $t('sku.name'),
    dataIndex: 'name',
    editable: true,
    role: customer.isEdit && customer.isJDGoods ? [1, 2] : [],
    inputType: 'btnText',
    roleRules: { required: false },
    disabeldRender: () => customer.isDisabled,
  },
  {
    title: $t('actions'),
    editable: true,
    dataIndex: 'option',
    role: [1, 2],
    inputType: 'option',
    roleProps: {
      isJDGoods: customer.isJDGoods,
      disabled: customer.isDisabled,
      min: 0,
    },
    roleRules: { required: false },
    disabeldRender: () => customer.isDisabled,
  },
];
export const ENUM_REPERTORY = [{ label: $t('single.specification'), value: '1' }, { label: $t('multispec'), value: '2' }];
export const ENUM_SET_REPERTORY = [{ label: $t('reset'), value: '0' }, { label: $t('max'), value: '1' }];
export const ENUM_WEEK = [
  { value: '1', label: $t('monday') },
  { value: '2', label: $t('tuesday') },
  { value: '3', label: $t('wednesday') },
  { value: '4', label: $t('thursday') },
  { value: '5', label: $t('friday') },
  { value: '6', label: $t('saturday') },
  { value: '7', label: $t('sunday') },
  // { value: 8, label: '法定假日' },
];
