import { Upload, Icon, Modal, message, Button, notification } from 'antd';
import React, { useState, useEffect } from 'react';
import config from '../../../../config/env.config';
import styles from '../style.less';
import UUID from '../../../utils/uuid';
import { qiniuToken } from '@/services/qiniu';

const qiniu = require('@/utils/qiniu.min.js');

const { qiniuHost } = config;

let token = null;

class PicturesWall extends React.Component {
  state = {
    fileList: [],
  };

  async componentDidMount() {
    this.initFileList(this.props.fileList || []);
    if (this.props.status === 1) {
      token = await qiniuToken();
    }
  }

  componentWillReceiveProps(nextProps) {
    if (!nextProps?.fileList?.fileList) {
      this.initFileList(nextProps.fileList || []);
    }
  }

  initFileList = fileList => {
    const fileLists =
      fileList.map((item, index) => ({
        url: item.url,
        name: item.name ? item.name : $t('invoice'),
        uid: index,
        status: 'done',
      })) || [];
    this.setState({ fileList: fileLists });
  };

  clearFileList = () => {
    this.setState({
      fileList: [],
    });
  };

  customRequest = ({ file, onError, onSuccess }) => {
    let filename = '';
    let suffix = '';
    if (file.name) {
      const index = file.name.lastIndexOf('.');
      filename = file.name.substr(0, index);
      suffix = file.name.substr(index + 1, file.name.length - 1);
      const types = ['pdf', 'doc', 'docx', 'zip', 'rar', 'png', 'jpeg'];
      if (!types.includes(suffix)) {
        message.error($t('invalid.file.format'));
        return;
      }
    }
    const vm = this;
    // eslint-disable-next-line new-cap
    const data = `${UUID.createUUID()}.${suffix}`;
    if (!token) {
      message.error($t('upload.failed.refresh.and.retry'));
      return;
    }
    const observable = qiniu.upload(file, data, token);
    const observer = {
      next() {
        // ...
      },
      error(t) {
        if (t.code === 614) {
          notification.error({
            message: $t('duplicate.filename'),
          });
        }
        onError(file);
        // ...
      },
      complete(res) {
        const comFile = file;
        const url = `${qiniuHost}/${res.key}`;
        comFile.url = url;
        const list = vm.state.fileList;
        list.push({
          url: file.url,
          name: file.name,
          uid: list.length,
          status: 'done',
        });
        vm.setState({ fileList: [...list] });
        vm.props.onChange(list);

        onSuccess(comFile);
        // ...
      },
    };
    observable.subscribe(observer); // 上传开始
  };

  clearFileList = () => {
    this.setState({
      fileList: [],
    });
  };

  render() {
    const { fileList } = this.state;
    const { status } = this.props;

    const uploadButton = (
      <div className={styles.uploadButton}>
        <Icon type="upload" />
        <span style={{ paddingLeft: '10px' }}>{$t('click.to.upload.invoice')}</span>
      </div>
    );
    const { max } = this.props;
    return (
      <div className="clearfix">
        <Upload
          {...this.props}
          customRequest={this.customRequest}
          listType="text"
          fileList={fileList}
          disabled={status !== 1}
          onRemove={status === 1 ? this.clearFileList : ''}
          accept=".pdf,.doc,.docx,.zip,.rar,.png,.jpeg"
        >
          {max && fileList.length >= max ? null : uploadButton}
        </Upload>
      </div>
    );
  }
}
export default PicturesWall;
