import React from 'react';
import { Modal, Form, InputNumber } from 'antd';
import styles from '../../style.less';

const MinimumPurchase = options => {
  const [form] = Form.useForm();
  const handleCancel = () => {
    options.cancel(false);
  };
  const handleOk = async () => {
    const values = await form.validateFields();
    console.log('values :>> ', values);
    options.confirm({
      type: 5,
      ...values,
    });
  };

  return (
    <Modal
      visible={options.visible}
      title={$t('edit.minimum.purchase')}
      onOk={handleOk}
      maskClosable={false}
      keyboard={false}
      confirmLoading={options.loading}
      destroyOnClose
      onCancel={handleCancel}
    >
      <Form
        name="basic"
        form={form}
        labelCol={{ span: 6 }}
        wrapperCol={{ span: 16 }}
        initialValues={{ minPurchaseNum: 1 }}
        autoComplete="off"
      >
        <Form.Item
          label={$t('min.purchaseportion')}
          name="minPurchaseNum"
          rules={[{ required: true, message: $t('minimum.quantity.required') }]}
        >
          <InputNumber min={1} max={999999} className={styles.inputWdith} />
        </Form.Item>
      </Form>
    </Modal>
  );
};

export default MinimumPurchase;
