import React from 'react';
import { Button } from 'antd';
import styles from '../style.less';

const productType = {
  1: $t('regular.product'),
  2: $t('virtual.product'),
  3: $t('evoucher'),
  4: $t('service.product'),
  5: $t('delivery.products'),
};

export const columns = ({ onDel, onEdit }) => [
  {
    title: $t('draft.id'),
    dataIndex: 'id',
    width: 85,
    align: 'center',
  },
  {
    title: $t('product.name'),
    dataIndex: 'productName',
    align: 'center',
    render(text) {
      return <div className={styles.draftName}>{text}</div>;
    },
  },
  {
    title: $t('belonging.category'),
    dataIndex: 'leimu',
    width: 240,
    align: 'center',
    render(text, record) {
      if (record.firstCategoryName) {
        return `${record.firstCategoryName}>${record.secondCategoryName}>${record.thirdCategoryName}`;
      }
      return '-';
    },
  },
  {
    title: $t('product.type'),
    dataIndex: 'productType',
    width: 100,
    align: 'center',
    render(text) {
      return productType[text];
    },
  },
  {
    title: $t('creation.time'),
    dataIndex: 'createdAt',
    width: 120,
    align: 'center',
  },
  {
    title: $t('actions'),
    dataIndex: 'action',
    width: 130,
    align: 'center',
    render: (text, record) => (
      <>
        <Button key="edit" type="link" size="small" onClick={() => onEdit(record)}>{$t('edit')}</Button>
        <Button key="viewP" type="link" size="small" onClick={() => onDel(record)}>{$t('delete')}</Button>
      </>
    ),
  },
];
