/* eslint-disable no-param-reassign */
import { Form, Select, Input, InputNumber, Button } from 'antd';
import React, { Component } from 'react';
// import styles from '../style.less';

const { Option } = Select;

const FormItem = Form.Item;

class goodsManage extends Component {
  componentDidMount() {
    this.props.onRef(this);
  }

  setFiled = flag => {
    const { form } = this.props;
    if (flag === 'firstKeys') {
      form.setFieldsValue({ firstSpecValue: '' });
      return;
    }
    form.setFieldsValue({ secondSpecValue: '' });
  };

  batchSetting = () => {
    const { form, editData, isEdit } = this.props;
    const data = form.getFieldsValue();
    if (!data.firstSpecValue && !data.secondSpecValue) {
      editData.forEach(item => {
        item.marketPrice = data.marketPrice;
        // item.salePrice = data.salePrice;
        if (!isEdit) item.productStock = data.productStock; // 编辑状态不可修改库存
        item.supplyPrice = data.supplyPrice;
        item.weight = data.weight;
        item.productStockWarning = data.productStockWarning;
      });
    }
    if (data.firstSpecValue && !data.secondSpecValue) {
      editData.forEach(item => {
        if (item.firstSpecValue === data.firstSpecValue) {
          item.marketPrice = data.marketPrice;
          // item.salePrice = data.salePrice;
          if (!isEdit) item.productStock = data.productStock;
          item.supplyPrice = data.supplyPrice;
          item.weight = data.weight;
          item.productStockWarning = data.productStockWarning;
        }
      });
    }
    if (!data.firstSpecValue && data.secondSpecValue) {
      editData.forEach(item => {
        if (item.secondSpecValue === data.secondSpecValue) {
          item.marketPrice = data.marketPrice;
          // item.salePrice = data.salePrice;
          if (!isEdit) item.productStock = data.productStock;
          item.supplyPrice = data.supplyPrice;
          item.weight = data.weight;
          item.productStockWarning = data.productStockWarning;
        }
      });
    }
    if (data.firstSpecValue && data.secondSpecValue) {
      editData.forEach(item => {
        if (
          item.firstSpecValue === data.firstSpecValue &&
          item.secondSpecValue === data.secondSpecValue
        ) {
          item.marketPrice = data.marketPrice;
          // item.salePrice = data.salePrice;
          if (!isEdit) item.productStock = data.productStock;
          item.supplyPrice = data.supplyPrice;
          item.weight = data.weight;
          item.productStockWarning = data.productStockWarning;
        }
      });
    }
    this.props.batchSetting(editData);
  };

  render() {
    const {
      firstSpes = [],
      secondSpecs = [],
      firstSpesName = '',
      secondSpesName = '',
      productType,
      isEdit,
    } = this.props;
    const { getFieldDecorator } = this.props.form;
    return (
      <Form layout="inline" onSubmit={this.handleSubmit}>
        <FormItem>
          {getFieldDecorator('firstSpecValue', {})(
            <Select allowClear style={{ width: 120 }} placeholder={firstSpesName}>
              {firstSpes.length > 0 &&
                firstSpes.map(
                  item =>
                    item &&
                    typeof item === 'string' && (
                      <Option key={item} value={item}>
                        {item}
                      </Option>
                    ),
                )}
            </Select>,
          )}
        </FormItem>
        <FormItem>
          {getFieldDecorator('secondSpecValue', {})(
            <Select allowClear style={{ width: 120 }} placeholder={secondSpesName}>
              {secondSpecs.length &&
                secondSpecs.map(
                  item =>
                    item &&
                    typeof item === 'string' && (
                      <Option key={item} value={item}>
                        {item}
                      </Option>
                    ),
                )}
            </Select>,
          )}
        </FormItem>
        <FormItem>
          {getFieldDecorator('supplyPrice', {})(
            <Input placeholder="供货价" style={{ width: 100 }} />,
          )}
        </FormItem>
        <FormItem>
          {getFieldDecorator('marketPrice', {})(
            <Input placeholder="市场价" style={{ width: 100 }} />,
          )}
        </FormItem>
        {/* <FormItem>
          {getFieldDecorator('salePrice', {})(
            <Input placeholder="销售价" style={{ width: 100 }} />,
          )}
        </FormItem> */}
        {productType === 1 && (
          <FormItem>
            {getFieldDecorator('weight', {})(
              <InputNumber
                precision={3}
                max={999999.999}
                // eslint-disable-next-line radix
                placeholder="重量"
                style={{ width: 130 }}
              />,
            )}
          </FormItem>
        )}
        {!isEdit && (
          <FormItem>
            {getFieldDecorator('productStock', {})(
              <InputNumber
                precision={0}
                step={1}
                // eslint-disable-next-line radix
                formatter={val => parseInt(val, '10') || ''}
                placeholder="库存"
                style={{ width: 100 }}
              />,
            )}
          </FormItem>
        )}
        <FormItem>
          {getFieldDecorator('productStockWarning', {})(
            <InputNumber
              placeholder="库存预警"
              maxLength={5}
              min={0}
              precision={0}
              style={{ width: 100 }}
            />,
          )}
        </FormItem>
        <FormItem>
          <Button type="primary" htmlType="submit" onClick={this.batchSetting}>
            批量设置
          </Button>
        </FormItem>
      </Form>
    );
  }
}

export default Form.create()(goodsManage);
