import React, { useRef, useState } from 'react';
import { Form, Input, Button, Checkbox, Card } from 'antd';
import { history } from 'umi';
import styles from './style.less';

const Password = props => {
  const formRef = useRef();
  const onFinish = values => {
    console.log('Success:', values);
  };

  const onFinishFailed = errorInfo => {
    console.log('Failed:', errorInfo);
  };

  const goHome = () => {
    formRef.current.resetFields();
    history.push('/');
  };
  return (
    <div className={styles.div}>
      <Card className={styles.card}>
        <p>修改密码</p>
        <Form
          initialValues={{ remember: true }}
          onFinish={onFinish}
          onFinishFailed={onFinishFailed}
          autoComplete="off"
          className={styles.form}
          ref={formRef}
        >
          <Form.Item name="val" rules={[{ required: true, message: '请输入原密码!' }]}>
            <Input.Password placeholder="输入原密码" />
          </Form.Item>
          <Form.Item
            name="loginpass"
            rules={[
              { required: true, message: '请输入新密码！' },
              {
                message: '至少13最多18位且必须包含大小写字母、数字和特殊字符',
                pattern: /^(?=.*[a-z])(?=.*[A-Z])(?=.*\d)(?=.*[$@$!%*?&])[A-Za-z\d$@$!%*?&]{13,18}/,
              },
            ]}
          >
            <Input.Password placeholder="输入新密码" maxLength={18} />
          </Form.Item>
          <Form.Item
            name="cfmloginpass"
            rules={[
              { required: true, message: '请输入新密码！' },
              {
                message: '至少13位最多18位且必须包含大小写字母、数字和特殊字符',
                pattern: /^(?=.*[a-z])(?=.*[A-Z])(?=.*\d)(?=.*[$@$!%*?&])[A-Za-z\d$@$!%*?&]{13,18}/,
              },
              ({ getFieldValue }) => ({
                validator(rule, value) {
                  if (value && getFieldValue('loginpass') !== value) {
                    // eslint-disable-next-line prefer-promise-reject-errors
                    return Promise.reject('两次密码输入不一致');
                  }
                  return Promise.resolve();
                },
              }),
            ]}
          >
            <Input.Password placeholder="输入新密码" maxLength={18} />
          </Form.Item>
          <Form.Item className={styles.btn}>
            <Button type="primary" htmlType="submit">
              {' '}
              确认修改
            </Button>
            <Button type="primary" ghost onClick={goHome}>
              返回首页
            </Button>
          </Form.Item>
        </Form>
      </Card>
    </div>
  );
};

export default Password;
