import request from '@/utils/request';
import config from '../../../config/env.config';

import qs from 'qs';
import { da } from 'date-fns/locale';

const { kdspApi } = config;

// 获取地址
export const apiAddrArea = params =>
  request.post('/api/merchants/addresses/list', {
    prefix: kdspApi,
    data: params,
    emulateJSON: true,
  });

// 主营类目
export const apiCategoryList = params =>
  request.post('/product/category/list', { prefix: kdspApi, params });

// 服务设施
export const apiServiceFacility = () =>
  request.get('/api/merchants/suppliers/facilities/list', { prefix: kdspApi });

// 银行
export const apiBankList = () =>
  request.get('/api/merchants/suppliers/banks/list', { prefix: kdspApi });

// 订正
export const apiRevision = params =>
  request.post('/api/consoles/suppliers/register/revision', { prefix: kdspApi, data: params });

/**
 * 上传文件
 * imageType: 1-主头图，2-营业执照，3-电子签章，4-法人身份证国徽面，5-法人身份证人像面，6-类目所需资质，7-其它证件，8-开户许可证
 *            0: 默认值 不校验
 * */
export async function uploadFile(files, imageType = 0) {
  const params = new FormData();
  files.map(file => params.append('file', file));
  params.append('imageType', imageType);
  // image/upload
  const data = await request.post('/api/merchants/images/upload', {
    prefix: kdspApi,
    data: params,
    canRepeat: true,
  });
  return data;
}

// 新增商家端入驻申请
export const apiNewStoreInfo = params =>
  request.post(`${kdspApi}/api/merchants/suppliers/register`, { prefix: kdspApi, data: params });

// 图片内容识别
export const apiRecognize = params =>
  request.get(`/api/merchants/images/recognize?${qs.stringify(params)}`, { prefix: kdspApi });

// 编辑商户信息
export const apiEditStoreInfo = params =>
  request.post(`${kdspApi}/api/merchants/suppliers/pops/edit`, { prefix: kdspApi, data: params });

// 查询申请详情
export const apiApplyDetail = applyId =>
  request.get(`${kdspApi}/api/merchants/suppliers/register/detail?applyId=${applyId}`);

// 查询商户详情
export const apiBusinessDetail = businessId =>
  request.get(`${kdspApi}/api/merchants/suppliers/pops/detail/${businessId}`);
